/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import java.io.IOException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.engine.AbstractStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.server.layers.layer3.engine.IServerStorageEngine;
import org.neodatis.odb.core.server.layers.layer3.engine.ServerFileSystemInterface;
import org.neodatis.odb.core.server.transaction.ISessionManager;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.query.criteria.CollectionQueryResultAction;
import org.neodatis.odb.impl.core.server.transaction.ServerSession;

public class ServerStorageEngine
extends AbstractStorageEngine
implements IServerStorageEngine {
    private ISessionManager sessionManager;

    public ServerStorageEngine(IBaseIdentification parameters) {
        super(parameters);
    }

    @Override
    public IObjectWriter buildObjectWriter() {
        return this.provider.getServerObjectWriter(this);
    }

    @Override
    public IObjectReader buildObjectReader() {
        return this.provider.getServerObjectReader(this);
    }

    @Override
    public IObjectIntrospector buildObjectIntrospector() {
        return this.provider.getServerObjectIntrospector(this);
    }

    @Override
    public ITriggerManager buildTriggerManager() {
        return this.provider.getServerTriggerManager(this);
    }

    protected IFileSystemInterface buildFSI() throws IOException {
        return new ServerFileSystemInterface("data", this.baseIdentification, true, OdbConfiguration.getDefaultBufferSizeForData());
    }

    @Override
    public ISession getSession(boolean throwExceptionIfDoesNotExist) {
        return this.sessionManager.getSession(this.baseIdentification.getIdentification(), throwExceptionIfDoesNotExist);
    }

    @Override
    public ISession buildDefaultSession() {
        ICoreProvider provider = OdbConfiguration.getCoreProvider();
        if (this.sessionManager == null) {
            this.sessionManager = provider.getClientServerSessionManager();
        }
        ISession session = provider.getServerSession(this, "default");
        return session;
    }

    @Override
    public void addSession(ISession session, boolean readMetamodel) {
        this.sessionManager.addSession(session);
        super.addSession(session, readMetamodel);
    }

    @Override
    protected MetaModel getMetaModel() {
        return this.getSession(true).getMetaModel();
    }

    @Override
    public void commit() {
        super.commit();
    }

    @Override
    public OID writeObjectInfo(OID oid, NonNativeObjectInfo nnoi, long position, boolean updatePointers) {
        oid = super.writeObjectInfo(oid, nnoi, position, updatePointers);
        return oid;
    }

    public void deleteObjectWithOid(OID oid) {
        ObjectInfoHeader oih = this.getSession(true).getCache().getObjectInfoHeaderFromOid(oid, false);
        if (oih == null) {
            oih = this.getObjectReader().readObjectInfoHeaderFromOid(oid, true);
        }
        ClassInfo ci = this.getMetaModel().getClassInfoFromId(oih.getClassInfoId());
        String className = ci.getFullClassName();
        boolean hasTriggers = this.triggerManager.hasDeleteTriggersFor(className);
        NonNativeObjectInfo nnoi = null;
        if (hasTriggers) {
            nnoi = this.getObjectReader().readNonNativeObjectInfoFromOid(ci, oid, true, false);
            this.triggerManager.manageInsertTriggerBefore(className, nnoi);
        }
        super.deleteObjectWithOid(oid, false);
        if (hasTriggers) {
            this.triggerManager.manageInsertTriggerAfter(className, nnoi, oid);
        }
    }

    @Override
    public <T> Objects<T> getObjectInfos(IQuery query, boolean inMemory, int startIndex, int endIndex, boolean returnOjects) {
        IObjectReader reader = this.getObjectReader();
        CollectionQueryResultAction queryResultAction = new CollectionQueryResultAction(query, inMemory, this, returnOjects, reader.getInstanceBuilder());
        return reader.getObjectInfos(query, inMemory, startIndex, endIndex, returnOjects, queryResultAction);
    }

    public ClassInfo addClass(ClassInfo newClassInfo, boolean addDependentClasses) throws IOException {
        ClassInfo ci = this.getObjectWriter().addClass(newClassInfo, addDependentClasses);
        ServerSession lsession = (ServerSession)this.getSession(true);
        lsession.setClassInfoId(newClassInfo.getFullClassName(), ci.getId());
        return ci;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public ClassInfoList addClasses(ClassInfoList classInfoList) {
        return this.getObjectWriter().addClasses(classInfoList);
    }
}

