/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.server.connection.SameVmConnection;
import org.neodatis.odb.core.server.layers.layer3.IODBServerExt;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;
import org.neodatis.odb.core.server.message.CloseMessage;
import org.neodatis.odb.core.server.message.CloseMessageResponse;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ClientStorageEngine;

public class SameVmClientEngine
extends ClientStorageEngine {
    public static final String LOG_ID = "SameVmClientEngine";
    protected SameVmConnection connection;
    protected IODBServerExt server;

    public SameVmClientEngine(IODBServerExt server, String baseIdentifier) {
        super(server.getParameters(baseIdentifier, true));
        this.server = server;
        super.initODBConnection();
    }

    @Override
    public Message sendMessage(Message msg) {
        this.checkConnection();
        return this.connection.manageMessage(msg);
    }

    @Override
    protected void initMessageStreamer() {
        this.messageStreamer = null;
    }

    @Override
    protected void initODBConnection() {
    }

    private synchronized void checkConnection() {
        if (this.connection == null) {
            this.connection = new SameVmConnection(this.parameters.getBaseIdentifier(), this.server, true);
        }
    }

    @Override
    public void close() {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.parameters.getIdentification()));
        }
        CloseMessage msg = new CloseMessage(this.parameters.getBaseIdentifier(), this.connectionId);
        CloseMessageResponse rmsg = (CloseMessageResponse)this.sendMessage(msg);
        if (rmsg.hasError()) {
            throw new ODBRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while closing database :").addParameter(rmsg.getError()));
        }
        this.isClosed = true;
        this.provider.removeLocalTriggerManager(this);
    }
}

