/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.connection;

import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.server.connection.ConnectionAction;
import org.neodatis.odb.core.server.connection.ConnectionManager;
import org.neodatis.odb.core.server.connection.IConnection;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class DefaultServerConnection
implements IConnection {
    public static final String LOG_ID = "Connection";
    private String id;
    private ConnectionManager connectionManager;
    private IStorageEngine storageEngine;
    private String baseIdentifier;
    private Map<OID, Long> oidsLockedForUpdate;
    private Map<String, Long> lockedClasses;
    private String currentAction;
    private long currentActionStart;
    private long lastActionDuration;
    private String lastAction;
    private int[] actions;

    public DefaultServerConnection(ConnectionManager connectionManager, String connectionId, IStorageEngine storageEngine) {
        this.connectionManager = connectionManager;
        this.id = connectionId;
        this.storageEngine = storageEngine;
        this.baseIdentifier = storageEngine.getBaseIdentification().getIdentification();
        this.oidsLockedForUpdate = new OdbHashMap<OID, Long>();
        this.lockedClasses = new OdbHashMap<String, Long>();
        this.actions = new int[ConnectionAction.getNumberOfActions()];
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IStorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    @Override
    public void close() throws Exception {
        this.commit();
    }

    @Override
    public void commit() throws Exception {
        this.storageEngine.commit();
        this.releaseOidLocks();
        this.releaseClassLocks();
    }

    protected void releaseOidLocks() throws InterruptedException {
        OID oid2 = null;
        for (OID oid2 : this.oidsLockedForUpdate.keySet()) {
            this.connectionManager.unlockOidForConnection(oid2, this);
            if (!OdbConfiguration.isDebugEnabled(LOG_ID)) continue;
            DLogger.debug("Release object lock for " + oid2);
        }
        this.oidsLockedForUpdate.clear();
    }

    protected void releaseClassLocks() throws InterruptedException {
        for (String fullClassName : this.lockedClasses.keySet()) {
            this.connectionManager.unlockClass(fullClassName, this);
            if (!OdbConfiguration.isDebugEnabled(LOG_ID)) continue;
            DLogger.debug("Release class lock for " + fullClassName);
        }
        this.lockedClasses.clear();
    }

    @Override
    public synchronized void unlockObjectWithOid(OID oid) throws Exception {
        this.connectionManager.unlockOidForConnection(oid, this);
        this.oidsLockedForUpdate.remove(oid);
    }

    @Override
    public synchronized void unlockClass(String fullClassName) throws Exception {
        this.connectionManager.unlockClass(fullClassName, this);
        this.lockedClasses.remove(fullClassName);
    }

    @Override
    public void rollback() throws Exception {
        this.storageEngine.rollback();
        this.releaseOidLocks();
        this.releaseClassLocks();
    }

    @Override
    public synchronized boolean lockObjectWithOid(OID oid) throws InterruptedException {
        this.connectionManager.lockOidForConnection(oid, this);
        this.oidsLockedForUpdate.put(oid, new Long(OdbTime.getCurrentTimeInMs()));
        return true;
    }

    @Override
    public boolean lockClass(String fullClassName) throws InterruptedException {
        this.connectionManager.lockClassForConnection(fullClassName, this);
        this.lockedClasses.put(fullClassName, new Long(OdbTime.getCurrentTimeInMs()));
        return true;
    }

    @Override
    public void setCurrentAction(int action) {
        this.currentActionStart = OdbTime.getCurrentTimeInMs();
        this.currentAction = ConnectionAction.getActionLabel(action);
        this.actions[action] = this.actions[action] + 1;
    }

    @Override
    public void endCurrentAction() {
        this.lastAction = this.currentAction;
        this.lastActionDuration = OdbTime.getCurrentTimeInMs() - this.currentActionStart;
        this.currentAction = "-";
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("cid=" + this.id).append("\n\t\t+ Current action : ");
        buffer.append(this.currentAction).append("(").append(OdbTime.getCurrentTimeInMs() - this.currentActionStart).append("ms) | last action : ");
        buffer.append(this.lastAction).append("(").append(this.lastActionDuration).append("ms)");
        buffer.append("\n\t\t+ Actions : ");
        for (int i = 0; i < this.actions.length; ++i) {
            buffer.append(ConnectionAction.getActionLabel(i)).append("=").append(this.actions[i]).append(" | ");
        }
        buffer.append("\n\t\t+ Blocked Oid (").append(this.oidsLockedForUpdate.size()).append(") : ");
        buffer.append(this.oidsLockedForUpdate.keySet());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DefaultServerConnection)) {
            return false;
        }
        DefaultServerConnection c = (DefaultServerConnection)obj;
        return this.id.equals(c.id);
    }
}

