/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import java.util.Iterator;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.execution.IQueryFieldAction;
import org.neodatis.odb.core.query.values.ICustomQueryFieldAction;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.values.AverageValueAction;
import org.neodatis.odb.impl.core.query.values.CountAction;
import org.neodatis.odb.impl.core.query.values.FieldValueAction;
import org.neodatis.odb.impl.core.query.values.MaxValueAction;
import org.neodatis.odb.impl.core.query.values.MinValueAction;
import org.neodatis.odb.impl.core.query.values.SizeAction;
import org.neodatis.odb.impl.core.query.values.SublistAction;
import org.neodatis.odb.impl.core.query.values.SumAction;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ValuesCriteriaQuery
extends CriteriaQuery
implements IValuesQuery {
    private IOdbList<IQueryFieldAction> objectActions;
    private String[] groupByFieldList;
    private boolean hasGroupBy;
    private boolean returnInstance;

    public ValuesCriteriaQuery(Class aClass, OID oid) {
        super(aClass.getName());
        this.setOidOfObjectToQuery(oid);
        this.init();
    }

    public ValuesCriteriaQuery(Class aClass, ICriterion criteria) {
        super(aClass.getName(), criteria);
        this.init();
    }

    public ValuesCriteriaQuery(Class aClass) {
        super(aClass.getName());
        this.init();
    }

    public ValuesCriteriaQuery(String aFullClassName) {
        super(aFullClassName);
        this.init();
    }

    public ValuesCriteriaQuery(String aFullClassName, ICriterion criteria) {
        super(aFullClassName, criteria);
        this.init();
    }

    public ValuesCriteriaQuery(CriteriaQuery query) {
        this(query.getFullClassName(), query.getCriteria());
    }

    private void init() {
        this.objectActions = new OdbArrayList<IQueryFieldAction>();
        this.returnInstance = true;
    }

    @Override
    public IValuesQuery count(String alias) {
        this.objectActions.add(new CountAction(alias));
        return this;
    }

    @Override
    public IValuesQuery sum(String attributeName) {
        return this.sum(attributeName, attributeName);
    }

    @Override
    public IValuesQuery sum(String attributeName, String alias) {
        this.objectActions.add(new SumAction(attributeName, alias));
        return this;
    }

    @Override
    public IValuesQuery sublist(String attributeName, int fromIndex, int size, boolean throwException) {
        return this.sublist(attributeName, attributeName, fromIndex, size, throwException);
    }

    @Override
    public IValuesQuery sublist(String attributeName, String alias, int fromIndex, int size, boolean throwException) {
        this.objectActions.add(new SublistAction(attributeName, alias, fromIndex, size, throwException));
        return this;
    }

    @Override
    public IValuesQuery sublist(String attributeName, int fromIndex, int toIndex) {
        return this.sublist(attributeName, attributeName, fromIndex, toIndex);
    }

    @Override
    public IValuesQuery sublist(String attributeName, String alias, int fromIndex, int toIndex) {
        this.objectActions.add(new SublistAction(attributeName, alias, fromIndex, toIndex));
        return this;
    }

    @Override
    public IValuesQuery size(String attributeName) {
        return this.size(attributeName, attributeName);
    }

    @Override
    public IValuesQuery size(String attributeName, String alias) {
        this.objectActions.add(new SizeAction(attributeName, alias));
        return this;
    }

    @Override
    public IValuesQuery avg(String attributeName) {
        return this.avg(attributeName, attributeName);
    }

    @Override
    public IValuesQuery avg(String attributeName, String alias) {
        this.objectActions.add(new AverageValueAction(attributeName, alias));
        return this;
    }

    @Override
    public IValuesQuery max(String attributeName) {
        return this.max(attributeName, attributeName);
    }

    @Override
    public IValuesQuery max(String attributeName, String alias) {
        this.objectActions.add(new MaxValueAction(attributeName, alias));
        return this;
    }

    public IValuesQuery min(String attributeName) {
        return this.min(attributeName, attributeName);
    }

    public IValuesQuery min(String attributeName, String alias) {
        this.objectActions.add(new MinValueAction(attributeName, alias));
        return this;
    }

    @Override
    public IValuesQuery field(String attributeName) {
        return this.field(attributeName, attributeName);
    }

    @Override
    public IValuesQuery field(String attributeName, String alias) {
        this.objectActions.add(new FieldValueAction(attributeName, alias));
        return this;
    }

    public IValuesQuery custom(String attributeName, ICustomQueryFieldAction action) {
        return this.custom(attributeName, attributeName, action);
    }

    public IValuesQuery custom(String attributeName, String alias, ICustomQueryFieldAction action) {
        action.setAttributeName(attributeName);
        action.setAlias(alias);
        this.objectActions.add(action);
        return this;
    }

    @Override
    public IOdbList<IQueryFieldAction> getObjectActions() {
        return this.objectActions;
    }

    @Override
    public IOdbList<String> getAllInvolvedFields() {
        int i;
        OdbArrayList<String> l = new OdbArrayList<String>();
        OdbHashMap<Object, Object> map = new OdbHashMap<Object, Object>();
        l.addAll(super.getAllInvolvedFields());
        if (!l.isEmpty()) {
            for (int i2 = 0; i2 < l.size(); ++i2) {
                map.put(l.get(i2), l.get(i2));
            }
        }
        Iterator iterator = this.objectActions.iterator();
        IQueryFieldAction oa = null;
        String name = null;
        while (iterator.hasNext()) {
            oa = (IQueryFieldAction)iterator.next();
            if (oa.getClass() == CountAction.class || map.containsKey(name = oa.getAttributeName())) continue;
            l.add(name);
            map.put(name, name);
        }
        if (this.hasGroupBy) {
            for (i = 0; i < this.groupByFieldList.length; ++i) {
                name = this.groupByFieldList[i];
                if (map.containsKey(name)) continue;
                l.add(name);
                map.put(name, name);
            }
        }
        if (this.hasOrderBy()) {
            for (i = 0; i < this.orderByFields.length; ++i) {
                name = this.orderByFields[i];
                if (map.containsKey(name)) continue;
                l.add(name);
                map.put(name, name);
            }
        }
        map.clear();
        map = null;
        return l;
    }

    @Override
    public boolean isMultiRow() {
        boolean isMultiRow = true;
        IQueryFieldAction oa = null;
        boolean groupBy = this.hasGroupBy && this.groupByFieldList.length == 1;
        String oneGroupByField = null;
        Iterator iterator = this.objectActions.iterator();
        if (groupBy) {
            oneGroupByField = this.groupByFieldList[0];
            while (iterator.hasNext()) {
                oa = (IQueryFieldAction)iterator.next();
                if (!(oa instanceof FieldValueAction) || !oa.getAttributeName().equals(oneGroupByField)) continue;
                oa.setMultiRow(false);
            }
        }
        if ((iterator = this.objectActions.iterator()).hasNext()) {
            oa = (IQueryFieldAction)iterator.next();
            isMultiRow = oa.isMultiRow();
        }
        while (iterator.hasNext()) {
            oa = (IQueryFieldAction)iterator.next();
            if (isMultiRow == oa.isMultiRow()) continue;
            throw new ODBRuntimeException(NeoDatisError.VALUES_QUERY_NOT_CONSISTENT.addParameter(this));
        }
        return isMultiRow;
    }

    @Override
    public IValuesQuery groupBy(String fieldList) {
        this.groupByFieldList = OdbString.split(fieldList, ",");
        this.hasGroupBy = true;
        return this;
    }

    @Override
    public boolean hasGroupBy() {
        return this.hasGroupBy;
    }

    @Override
    public String[] getGroupByFieldList() {
        return this.groupByFieldList;
    }

    @Override
    public boolean returnInstance() {
        return this.returnInstance;
    }

    @Override
    public void setReturnInstance(boolean returnInstance) {
        this.returnInstance = returnInstance;
    }
}

