/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.query.execution.IndexTool;
import org.neodatis.odb.impl.core.query.list.values.InMemoryBTreeCollectionForValues;
import org.neodatis.odb.impl.core.query.list.values.SimpleListForValues;
import org.neodatis.odb.impl.core.query.values.ValuesQueryResultAction;
import org.neodatis.tool.wrappers.OdbComparable;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class GroupByValuesQueryResultAction
implements IMatchingObjectAction {
    private IValuesQuery query;
    private long nbObjects;
    private Map<OdbComparable, ValuesQueryResultAction> groupByResult;
    private Values result;
    private boolean queryHasOrderBy;
    protected IInstanceBuilder instanceBuilder;
    protected ClassInfo classInfo;
    private int returnArraySize;
    private String[] groupByFieldList;

    public GroupByValuesQueryResultAction(IValuesQuery query, IStorageEngine storageEngine, IInstanceBuilder instanceBuilder) {
        this.query = query;
        this.queryHasOrderBy = query.hasOrderBy();
        this.instanceBuilder = instanceBuilder;
        this.returnArraySize = query.getObjectActions().size();
        this.groupByFieldList = query.getGroupByFieldList();
        this.groupByResult = new OdbHashMap<OdbComparable, ValuesQueryResultAction>();
    }

    @Override
    public void objectMatch(OID oid, OdbComparable orderByKey) {
    }

    @Override
    public void objectMatch(OID oid, Object object, OdbComparable orderByKey) {
        AttributeValuesMap values = (AttributeValuesMap)object;
        OdbComparable groupByKey = IndexTool.buildIndexKey("GroupBy", values, this.groupByFieldList);
        ValuesQueryResultAction result = this.groupByResult.get(groupByKey);
        if (result == null) {
            result = new ValuesQueryResultAction(this.query, null, this.instanceBuilder);
            result.start();
            this.groupByResult.put(groupByKey, result);
        }
        result.objectMatch(oid, object, orderByKey);
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
        this.result = this.query != null && this.query.hasOrderBy() ? new InMemoryBTreeCollectionForValues((int)this.nbObjects, this.query.getOrderByType()) : new SimpleListForValues((int)this.nbObjects);
        Iterator<OdbComparable> iterator = this.groupByResult.keySet().iterator();
        ValuesQueryResultAction vqra = null;
        OdbComparable key = null;
        while (iterator.hasNext()) {
            key = iterator.next();
            vqra = this.groupByResult.get(key);
            vqra.end();
            this.merge(key, vqra.getValues());
        }
    }

    private void merge(OdbComparable key, Values values) {
        while (values.hasNext()) {
            if (this.queryHasOrderBy) {
                this.result.addWithKey(key, values.nextValues());
                continue;
            }
            this.result.add(values.nextValues());
        }
    }

    @Override
    public <T> Objects<T> getObjects() {
        return this.result;
    }
}

