/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.list.objects;

import java.util.Iterator;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.tool.wrappers.OdbComparable;
import org.neodatis.tool.wrappers.list.OdbArrayList;

public class LazySimpleListFromOid<T>
extends OdbArrayList<T>
implements Objects<T> {
    private int currentPosition;
    private IStorageEngine engine;
    private boolean returnInstance;

    public LazySimpleListFromOid(int size, IStorageEngine engine, boolean returnObjects) {
        super(size);
        this.engine = engine;
        this.returnInstance = returnObjects;
    }

    @Override
    public boolean addWithKey(OdbComparable key, T object) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public boolean addWithKey(int key, T object) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public T getFirst() {
        try {
            return this.get(0);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(0), (Throwable)e);
        }
    }

    @Override
    public T get(int index) {
        OID oid = (OID)super.get(index);
        try {
            if (this.returnInstance) {
                return (T)this.engine.getObjectFromOid(oid);
            }
            return (T)this.engine.getObjectReader().getObjectFromOid(oid, false, false);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(index));
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.size();
    }

    @Override
    public Iterator<T> iterator(OrderByConstants orderByType) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public T next() {
        try {
            return this.get(this.currentPosition++);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(0), (Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.currentPosition = 0;
    }

    @Override
    public boolean removeByKey(OdbComparable key, Object value) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED.addParameter("removeByKey on LazySimplelist, use remove instead"));
    }
}

