/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.criteria;

import java.util.Collection;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.criteria.AbstractCriterion;
import org.neodatis.tool.wrappers.OdbReflection;

public class CollectionSizeCriterion
extends AbstractCriterion {
    public static final int SIZE_EQ = 1;
    public static final int SIZE_NE = 2;
    public static final int SIZE_GT = 3;
    public static final int SIZE_GE = 4;
    public static final int SIZE_LT = 5;
    public static final int SIZE_LE = 6;
    private int size;
    private int sizeType;

    public CollectionSizeCriterion(String attributeName, int size, int sizeType) {
        super(attributeName);
        this.size = size;
        this.sizeType = sizeType;
    }

    @Override
    public boolean match(Object valueToMatch) {
        if (valueToMatch instanceof AttributeValuesMap) {
            AttributeValuesMap attributeValues = (AttributeValuesMap)valueToMatch;
            valueToMatch = attributeValues.getAttributeValue(this.attributeName);
        }
        if (valueToMatch == null) {
            if (this.sizeType == 1 && this.size == 0) {
                return true;
            }
            if (this.sizeType == 6 && this.size >= 0 || this.sizeType == 5 && this.size > 0) {
                return true;
            }
            return this.sizeType == 2 && this.size != 0;
        }
        if (valueToMatch instanceof Collection) {
            Collection c = (Collection)valueToMatch;
            return this.matchSize(c.size(), this.size, this.sizeType);
        }
        Class<?> clazz = valueToMatch.getClass();
        if (clazz.isArray()) {
            int arrayLength = OdbReflection.getArrayLength(valueToMatch);
            return this.matchSize(arrayLength, this.size, this.sizeType);
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_BAD_CRITERIA.addParameter(valueToMatch.getClass().getName()));
    }

    private boolean matchSize(int collectionSize, int requestedSize, int sizeType) {
        switch (sizeType) {
            case 1: {
                return collectionSize == requestedSize;
            }
            case 2: {
                return collectionSize != requestedSize;
            }
            case 3: {
                return collectionSize > requestedSize;
            }
            case 4: {
                return collectionSize >= requestedSize;
            }
            case 5: {
                return collectionSize < requestedSize;
            }
            case 6: {
                return collectionSize <= requestedSize;
            }
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_COLLECTION_SIZE_CRITERIA_NOT_SUPPORTED.addParameter(sizeType));
    }

    @Override
    public AttributeValuesMap getValues() {
        return new AttributeValuesMap();
    }

    @Override
    public void ready() {
    }
}

