/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.oid;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.tool.wrappers.OdbString;

public class OdbObjectOID
implements OID {
    protected long oid;

    public OdbObjectOID(long oid) {
        this.oid = oid;
    }

    public String toString() {
        return String.valueOf(this.oid);
    }

    @Override
    public String oidToString() {
        StringBuffer buffer = new StringBuffer("object-oid").append(":").append(String.valueOf(this.oid));
        return buffer.toString();
    }

    public static OdbObjectOID oidFromString(String oidString) {
        String[] tokens = OdbString.split(oidString, ":");
        if (tokens.length != 2 || !tokens[0].equals("object-oid")) {
            throw new ODBRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(oidString));
        }
        long oid = Long.parseLong(tokens[1]);
        return new OdbObjectOID(oid);
    }

    @Override
    public long getObjectId() {
        return this.oid;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof OdbObjectOID)) {
            return -1000;
        }
        OID otherOid = (OID)object;
        return (int)(this.oid - otherOid.getObjectId());
    }

    public boolean equals(Object object) {
        boolean b = this == object || this.compareTo(object) == 0;
        return b;
    }

    public int hashCode() {
        return (int)(this.oid ^ this.oid >>> 32);
    }

    @Override
    public long getClassId() {
        return 0L;
    }

    @Override
    public int getType() {
        return 2;
    }
}

