/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.gui.connect.Connection;
import org.neodatis.odb.gui.connect.ConnectionPanel;
import org.neodatis.odb.gui.connect.LocalConnectionPanel;
import org.neodatis.odb.gui.connect.RemoteConnectionPanel;
import org.neodatis.tool.ILogger;

public class MainConnectPanel
extends JDialog
implements ActionListener {
    private JTabbedPane tabs;
    private ILogger logger;
    private Connection connection;
    private boolean dataAreOk;

    public MainConnectPanel(Frame frame, ILogger logger) {
        super(frame, "ODB Connection", true);
        this.logger = logger;
        this.initGUI();
    }

    private void initGUI() {
        LocalConnectionPanel panel1 = new LocalConnectionPanel(this.logger);
        RemoteConnectionPanel panel2 = new RemoteConnectionPanel(this.logger);
        panel1.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tabs = new JTabbedPane();
        this.tabs.add(Messages.getString("Local connections"), panel1);
        this.tabs.add(Messages.getString("Remote connections"), panel2);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)GUITool.buildHeaderPanel("ODB Connection Wizard"), "North");
        panel.add((Component)this.tabs, "Center");
        JButton btConnect = new JButton(Messages.getString("Connect"));
        btConnect.setActionCommand("connect");
        btConnect.addActionListener(this);
        JPanel panelButton = new JPanel();
        JButton btQuit = new JButton(Messages.getString("Quit"));
        btQuit.setActionCommand("quit");
        btQuit.addActionListener(this);
        panelButton.add(btQuit);
        panelButton.add(btConnect);
        panel.add((Component)panelButton, "South");
        this.getContentPane().add(panel);
    }

    public static void main(String[] args) {
        LoggerPanel loggerPanel = new LoggerPanel();
        MainConnectPanel mcp = new MainConnectPanel(null, loggerPanel);
        mcp.setDefaultCloseOperation(3);
        mcp.pack();
        mcp.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("connect".equals(action)) {
            try {
                this.connect();
            }
            catch (Exception e1) {
                this.logger.error("Unable to connect", e1);
            }
        }
        if ("quit".equals(action)) {
            this.setVisible(false);
            this.connection = null;
        }
    }

    private void connect() throws Exception {
        ConnectionPanel panel = (ConnectionPanel)this.tabs.getSelectedComponent();
        this.dataAreOk = panel.validateData();
        if (this.dataAreOk) {
            this.setVisible(false);
            this.connection = panel.getConnection();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

