/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.neodatis.odb.gui.component.CentredBackgroundBorder;

public class GUITool {
    private static final String FONT = "<font size=\"3\" face=\"Verdana\">";
    private static final String HEADER_IMG_FILE_NAME = "/img/header.png";
    private static final String LOGO_IMG = "/img/logo.png";
    private static BufferedImage HEADER_IMG = null;

    public static JPanel buildLogoPanel(String text) {
        final JPanel headerPanel = new JPanel(new FlowLayout(2));
        headerPanel.setPreferredSize(new Dimension(600, 30));
        String surl = "/img/logo.jpg";
        Runnable r = new Runnable(){

            @Override
            public void run() {
                URL url = null;
                try {
                    url = new File(GUITool.LOGO_IMG).toURL();
                    CentredBackgroundBorder bkgrnd = new CentredBackgroundBorder(ImageIO.read(url));
                    headerPanel.setBorder(bkgrnd);
                    headerPanel.repaint();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(r);
        JLabel headerLabel = new JLabel("<html><font size=\"3\" face=\"Verdana\"><b>" + text + "</b></font><html>", 4);
        headerLabel.setForeground(Color.WHITE);
        headerPanel.add(headerLabel);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(new BevelBorder(0));
        panel.add(headerPanel);
        return panel;
    }

    public static JPanel buildHeaderPanel(String text) {
        JPanel headerPanel = new JPanel(new FlowLayout(0));
        headerPanel.setPreferredSize(new Dimension(600, 30));
        CentredBackgroundBorder bkgrnd = null;
        if (HEADER_IMG != null) {
            bkgrnd = new CentredBackgroundBorder(HEADER_IMG);
            headerPanel.setBorder(bkgrnd);
        }
        JLabel headerLabel = new JLabel("<html><font size=\"3\" face=\"Verdana\"><b>" + text + "</b></font><html>", 2);
        headerLabel.setForeground(Color.WHITE);
        headerPanel.add(headerLabel);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(new BevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
        panel.add(headerPanel);
        return panel;
    }

    static {
        try {
            URL url = new File(HEADER_IMG_FILE_NAME).toURL();
            HEADER_IMG = ImageIO.read(url.getClass().getResourceAsStream(HEADER_IMG_FILE_NAME));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

