/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.classbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoHelper;
import org.neodatis.odb.gui.classbrowser.ClassAttributeInfoWrapper;
import org.neodatis.odb.gui.classbrowser.ClassHierarchyPanel;
import org.neodatis.odb.gui.classbrowser.ClassInfoWrapper;
import org.neodatis.tool.wrappers.OdbClassUtil;

public class MyMouseListener
extends MouseAdapter
implements ActionListener {
    private static final int TYPE_CLASS = 1;
    private static final int TYPE_FIELD = 2;
    private JTree tree;
    private ClassHierarchyPanel panel;
    private ClassInfo currentClassInfo;
    private ClassAttributeInfo currentClassAttributeInfo;
    private int actionType;

    public MyMouseListener(JTree tree, ClassHierarchyPanel panel) {
        this.tree = tree;
        this.panel = panel;
        this.currentClassInfo = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TreePath path = this.tree.getClosestPathForLocation(e.getX(), e.getY());
        Object object = path.getLastPathComponent();
        if (object == null) {
            System.out.println("Object is null");
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (object instanceof ClassInfoWrapper) {
                ClassInfoWrapper ciw = (ClassInfoWrapper)object;
                this.currentClassInfo = ciw.getCi();
                this.actionType = 1;
                this.buildPopupForClass(ciw, e.getX(), e.getY());
            }
            if (object instanceof ClassAttributeInfoWrapper) {
                ClassAttributeInfoWrapper caiw = (ClassAttributeInfoWrapper)object;
                this.actionType = 1;
                this.currentClassInfo = caiw.getCi();
                this.currentClassAttributeInfo = caiw.getCai();
                this.buildPopupForAttribute(caiw, e.getX(), e.getY());
            }
        }
    }

    public void buildPopupForClass(ClassInfoWrapper classInfoToBrowse, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(":: Class " + OdbClassUtil.getClassName(classInfoToBrowse.getCi().getFullClassName()));
        popup.add(menuItem);
        popup.addSeparator();
        popup.add(this.buildMenuItem("Object view", "object-view", null));
        popup.add(this.buildMenuItem("Table view", "table-view", null));
        popup.add(this.buildMenuItem("Query", "query", null));
        popup.add(this.buildMenuItem("New Object", "new-object", null));
        JMenu menuRefactor = new JMenu("Refactor");
        menuItem = this.buildMenuItem("Rename class", "refactor-rename-class", null);
        menuRefactor.add(menuItem);
        menuItem = this.buildMenuItem("Add a field to class", "refactor-add-field", null);
        menuRefactor.add(menuItem);
        popup.add(menuRefactor);
        List<String> indexNames = ClassInfoHelper.getIndexNames(classInfoToBrowse.getCi());
        JMenu menuIndexes = null;
        menuIndexes = indexNames.isEmpty() ? new JMenu("No index") : new JMenu(String.format("%d index(es)", indexNames.size()));
        JMenu menu = null;
        for (String name : indexNames) {
            menu = this.buildMenu(name, null);
            menuIndexes.add(menu);
            menuItem = this.buildMenuItem("is unique ? " + (ClassInfoHelper.indexIsUnique(classInfoToBrowse.getCi(), name) ? "yes" : "no"), "none", null);
            menu.add(menuItem);
            menuItem = this.buildMenuItem("attributes = " + ClassInfoHelper.getIndexAttributes(classInfoToBrowse.getCi(), name), "none", null);
            menu.add(menuItem);
            menuItem = this.buildMenuItem("size = " + ClassInfoHelper.getIndexSize(classInfoToBrowse.getCi(), name), "none", null);
            menu.add(menuItem);
            menuItem = this.buildMenuItem("rebuild", "rebuild-index:" + name, null);
            menu.add(menuItem);
        }
        popup.add(menuIndexes);
        popup.show(this.tree, x, y);
    }

    public void buildPopupForAttribute(ClassAttributeInfoWrapper classAttributeInfoWrapper, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Field " + classAttributeInfoWrapper.getCai().getName());
        popup.add(menuItem);
        popup.addSeparator();
        JMenu menu2 = new JMenu("Refactor");
        menuItem = this.buildMenuItem("Rename field", "refactor-rename-field", null);
        menu2.add(menuItem);
        menuItem = this.buildMenuItem("Remove field", "refactor-remove-field", null);
        menu2.add(menuItem);
        popup.add(menu2);
        popup.show(this.tree, x, y);
    }

    protected JMenuItem buildMenuItem(String label, String action, String img) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.setActionCommand(action);
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected JMenu buildMenu(String label, String img) {
        JMenu menu = new JMenu(label);
        menu.addActionListener(this);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        this.panel.actionPerformed(action, this.currentClassInfo, this.currentClassAttributeInfo);
        this.actionType = 0;
        this.currentClassAttributeInfo = null;
        this.currentClassInfo = null;
    }
}

