/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import org.neodatis.odb.ODBAuthenticationRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.IBrowserContainer;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.classbrowser.ClassHierarchyPanel;
import org.neodatis.odb.gui.tool.GuiUtil;
import org.neodatis.odb.gui.xml.XmlExportPanel;
import org.neodatis.tool.ILogger;

public class ODBExplorerPanel
extends JPanel
implements IBrowserContainer,
ActionListener {
    private IBaseIdentification baseIdentification;
    private IStorageEngine engine;
    private ClassHierarchyPanel classHierarchyPanel;
    private JTabbedPane browsingPanel;
    private JSplitPane pane;
    private JInternalFrame graphicContainer;
    private ILogger logger;
    private JButton closeButton;
    private JButton updateButton;
    private JButton commitButton;
    private JButton rollbackButton;

    public ODBExplorerPanel(JInternalFrame graphicContainer, IBaseIdentification baseIdentification, String title, ILogger logger) {
        this.baseIdentification = baseIdentification;
        this.graphicContainer = graphicContainer;
        this.logger = logger;
        this.init(title);
    }

    private void init(String title) {
        this.updateEngine();
        this.classHierarchyPanel = new ClassHierarchyPanel(this.engine, this, title, this.logger);
        this.browsingPanel = new JTabbedPane();
        this.browsingPanel.setPreferredSize(new Dimension(600, 400));
        this.browsingPanel.setAutoscrolls(true);
        this.pane = new JSplitPane(1, this.classHierarchyPanel, this.browsingPanel);
        this.pane.setDividerLocation(0.3);
        this.setLayout(new BorderLayout(4, 4));
        this.add(this.pane);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel1 = new JPanel();
        JPanel buttonPanel2 = new JPanel();
        this.updateButton = new JButton(Messages.getString("Refresh"));
        this.updateButton.addActionListener(this);
        this.updateButton.setActionCommand("refresh");
        buttonPanel1.add(this.updateButton);
        this.commitButton = new JButton(Messages.getString("Commit"));
        this.commitButton.addActionListener(this);
        this.commitButton.setActionCommand("commit");
        buttonPanel1.add(this.commitButton);
        this.rollbackButton = new JButton(Messages.getString("Rollback"));
        this.rollbackButton.addActionListener(this);
        this.rollbackButton.setActionCommand("rollback");
        buttonPanel1.add(this.rollbackButton);
        this.closeButton = new JButton(Messages.getString("Close Database"));
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        buttonPanel2.add(this.closeButton);
        buttonPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        buttonPanel.add((Component)buttonPanel1, "Center");
        buttonPanel.add((Component)buttonPanel2, "East");
        this.add((Component)buttonPanel, "South");
    }

    public void updateEngine() {
        if (this.engine != null) {
            this.engine.close();
        }
        if (this.baseIdentification.isLocal()) {
            try {
                this.engine = OdbConfiguration.getCoreProvider().getClientStorageEngine(this.baseIdentification);
                this.logger.info("connected!");
            }
            catch (ODBAuthenticationRuntimeException e) {
                JOptionPane.showMessageDialog(this, "Invalid user/password");
            }
            catch (Exception e) {
                this.logger.error("Error while opening base", e);
            }
        } else {
            try {
                this.engine = OdbConfiguration.getCoreProvider().getClientStorageEngine(this.baseIdentification);
            }
            catch (ODBAuthenticationRuntimeException e) {
                JOptionPane.showMessageDialog(this, "Invalid user/password");
            }
        }
        if (this.classHierarchyPanel != null) {
            this.classHierarchyPanel.updateEngine(this.engine);
        }
    }

    @Override
    public void browse(String title, JPanel panel, int nbObjects) {
        JPanel container = new JPanel(new BorderLayout(4, 4));
        container.add(panel);
        JButton closeButton = new JButton(Messages.getString("Click here to close the Tab"));
        final int index = this.browsingPanel.getTabCount();
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODBExplorerPanel.this.browsingPanel.removeTabAt(index);
            }
        });
        container.add((Component)closeButton, "South");
        if (nbObjects != -1) {
            this.browsingPanel.addTab(title + "(" + nbObjects + " objects)", container);
        } else {
            this.browsingPanel.addTab(title, container);
        }
        this.browsingPanel.setSelectedIndex(this.browsingPanel.getTabCount() - 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == null) {
            return;
        }
        if (actionCommand.equals("commit")) {
            try {
                this.commit();
            }
            catch (Exception e1) {
                this.logger.error("Error while commiting", e1);
            }
        }
        if (actionCommand.equals("refresh")) {
            try {
                this.updateEngine();
            }
            catch (Exception e1) {
                this.logger.error("Error while refreshing", e1);
            }
        }
        if (actionCommand.equals("rollback")) {
            try {
                this.rollback();
            }
            catch (IOException e1) {
                this.logger.error("Error while rollbacking", e1);
            }
        }
        if (actionCommand.equals("close")) {
            this.close();
        }
        if (actionCommand.equals("export-xml")) {
            try {
                this.exportToXML();
            }
            catch (Exception e1) {
                this.logger.error("Error while exporting to xml", e1);
                JOptionPane.showMessageDialog(this, "Error while exporting to xml : " + e1.getMessage());
            }
        }
    }

    private void close() {
        int r;
        if (this.engine.getSession(true).transactionIsPending()) {
            this.logger.error(Messages.getString("Some work has not been commited,\nplease commit or rollback current session!"));
        } else if (this.graphicContainer != null && (r = JOptionPane.showConfirmDialog(this, Messages.getString("Do you really want to close the database"), Messages.getString("Confirmation"), 0)) == 0) {
            this.graphicContainer.dispose();
            this.logger.info("Closing engine");
            this.engine.close();
        }
    }

    private void commit() throws Exception {
        this.engine.commit();
        this.logger.info("Commit executed");
    }

    private void rollback() throws IOException {
        this.engine.rollback();
        this.logger.info("Rollback executed");
    }

    private void exportToXML() {
        XmlExportPanel panel = new XmlExportPanel(this.logger);
        final JDialog dialog = new JDialog();
        dialog.setTitle(Messages.getString("XML Exportation"));
        dialog.getContentPane().add(panel);
        JButton btClose = new JButton(Messages.getString("Close"));
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add((Component)btClose, "South");
        dialog.setModal(true);
        dialog.pack();
        GuiUtil.centerScreen(dialog);
    }
}

