/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.tool.wrappers.OdbClassUtil;

public class ClassAttributeInfo
implements Serializable {
    private int id;
    private ClassInfo classInfo;
    private String className;
    private String packageName;
    private String name;
    private boolean isIndex;
    private String fullClassName;
    private ODBType attributeType;
    private transient Class nativeClass;

    public ClassAttributeInfo() {
    }

    public ClassAttributeInfo(int attributeId, String name, String fullClassName, ClassInfo info) {
        this(attributeId, name, null, fullClassName, info);
    }

    public ClassAttributeInfo(int attributeId, String name, Class nativeClass, String fullClassName, ClassInfo info) {
        this.id = attributeId;
        this.name = name;
        this.nativeClass = nativeClass;
        this.setFullClassName(fullClassName);
        if (nativeClass != null) {
            this.attributeType = ODBType.getFromClass(nativeClass);
        } else if (fullClassName != null) {
            this.attributeType = ODBType.getFromName(fullClassName);
        }
        this.classInfo = info;
        this.isIndex = false;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public void setIndex(boolean isIndex) {
        this.isIndex = isIndex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNative() {
        return this.attributeType.isNative();
    }

    public boolean isNonNative() {
        return !this.attributeType.isNative();
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
        this.setClassName(OdbClassUtil.getClassName(fullClassName));
        this.setPackageName(OdbClassUtil.getPackageName(fullClassName));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("id=").append(this.id).append(" name=").append(this.name).append(" | is Native=").append(this.isNative()).append(" | type=").append(this.getFullClassname()).append(" | isIndex=").append(this.isIndex);
        return buffer.toString();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getFullClassname() {
        if (this.fullClassName != null) {
            return this.fullClassName;
        }
        if (this.packageName == null || this.packageName.length() == 0) {
            this.fullClassName = this.className;
            return this.className;
        }
        this.fullClassName = this.packageName + "." + this.className;
        return this.fullClassName;
    }

    public void setAttributeType(ODBType attributeType) {
        this.attributeType = attributeType;
    }

    public ODBType getAttributeType() {
        return this.attributeType;
    }

    public Class getNativeClass() {
        return this.nativeClass;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

