/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;

public abstract class AbstractObjectInfo
implements Serializable {
    protected int odbTypeId;
    protected ODBType odbType;
    protected long position;

    public AbstractObjectInfo(int typeId) {
        this.odbTypeId = typeId;
    }

    public AbstractObjectInfo(ODBType type) {
        if (type != null) {
            this.odbTypeId = type.getId();
        }
        this.odbType = type;
    }

    public boolean isNative() {
        return this.isAtomicNativeObject() || this.isArrayObject() || this.isCollectionObject() || this.isMapObject();
    }

    public boolean isGroup() {
        return this.isCollectionObject() || this.isMapObject() || this.isArrayObject();
    }

    public boolean isNull() {
        return this.getObject() == null;
    }

    public abstract Object getObject();

    public abstract void setObject(Object var1);

    public int getOdbTypeId() {
        return this.odbTypeId;
    }

    public void setOdbTypeId(int odbTypeId) {
        this.odbTypeId = odbTypeId;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public ODBType getOdbType() {
        if (this.odbType == null) {
            this.odbType = ODBType.getFromId(this.odbTypeId);
        }
        return this.odbType;
    }

    public void setOdbType(ODBType odbType) {
        this.odbType = odbType;
    }

    public boolean isNonNativeObject() {
        return false;
    }

    public boolean isAtomicNativeObject() {
        return false;
    }

    public boolean isCollectionObject() {
        return false;
    }

    public boolean isMapObject() {
        return false;
    }

    public boolean isArrayObject() {
        return false;
    }

    public boolean isDeletedObject() {
        return false;
    }

    public boolean isObjectReference() {
        return false;
    }

    public boolean isEnumObject() {
        return false;
    }

    public abstract AbstractObjectInfo createCopy(Map<OID, AbstractObjectInfo> var1, boolean var2);
}

