/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.tool;

import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreeNodeOneValuePerKey;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.exception.BTreeNodeValidationException;

public class BTreeValidator {
    private static boolean on = false;

    public static boolean isOn() {
        return on;
    }

    public static void setOn(boolean on) {
        BTreeValidator.on = on;
    }

    public static void checkDuplicateChildren(IBTreeNode node1, IBTreeNode node2) {
        if (!on) {
            return;
        }
        for (int i = 0; i < node1.getNbChildren(); ++i) {
            IBTreeNode child1 = node1.getChildAt(i, true);
            for (int j = 0; j < node2.getNbChildren(); ++j) {
                if (child1 != node2.getChildAt(j, true)) continue;
                throw new BTreeNodeValidationException("Duplicated node : " + child1);
            }
        }
    }

    public static void validateNode(IBTreeNode node, boolean isRoot) {
        if (!on) {
            return;
        }
        BTreeValidator.validateNode(node);
        if (isRoot && node.hasParent()) {
            throw new BTreeNodeValidationException("Root node with a parent: " + node.toString());
        }
        if (!isRoot && !node.hasParent()) {
            throw new BTreeNodeValidationException("Internal node without parent: " + node.toString());
        }
    }

    public static void validateNode(IBTreeNode node) {
        int i;
        int i2;
        if (!on) {
            return;
        }
        int nbKeys = node.getNbKeys();
        if (node.hasParent() && nbKeys < node.getDegree() - 1) {
            throw new BTreeNodeValidationException("Node with less than " + (node.getDegree() - 1) + " keys");
        }
        int maxNbKeys = node.getDegree() * 2 - 1;
        int nbChildren = node.getNbChildren();
        int maxNbChildren = node.getDegree() * 2;
        if (nbChildren != 0 && nbKeys == 0) {
            throw new BTreeNodeValidationException("Node with no key but with children : " + node);
        }
        for (i2 = 0; i2 < nbKeys; ++i2) {
            if (node.getKeyAndValueAt(i2) == null) {
                throw new BTreeNodeValidationException("Null key at " + i2 + " on node " + node.toString());
            }
            BTreeValidator.checkValuesOfChild(node.getKeyAndValueAt(i2), node.getChildAt(i2, false));
        }
        for (i2 = nbKeys; i2 < maxNbKeys; ++i2) {
            if (node.getKeyAndValueAt(i2) == null) continue;
            throw new BTreeNodeValidationException("Not Null key at " + i2 + " on node " + node.toString());
        }
        IBTreeNode previousNode = null;
        for (i = 0; i < nbChildren; ++i) {
            if (node.getChildAt(i, false) == null) {
                throw new BTreeNodeValidationException("Null child at index " + i + " on node " + node.toString());
            }
            if (previousNode != null && previousNode == node.getChildAt(i, false)) {
                throw new BTreeNodeValidationException("Two equals children at index " + i + " : " + previousNode.toString());
            }
            previousNode = node.getChildAt(i, false);
        }
        for (i = nbChildren; i < maxNbChildren; ++i) {
            if (node.getChildAt(i, false) == null) continue;
            throw new BTreeNodeValidationException("Not Null child at " + i + " on node " + node.toString());
        }
    }

    private static void checkValuesOfChild(IKeyAndValue key, IBTreeNode node) {
        if (!on) {
            return;
        }
        if (node == null) {
            return;
        }
        for (int i = 0; i < node.getNbKeys(); ++i) {
            if (node.getKeyAndValueAt(i).getKey().compareTo(key.getKey()) < 0) continue;
            throw new BTreeNodeValidationException("Left child with values bigger than pivot " + key + " : " + node.toString());
        }
    }

    public static boolean searchKey(Comparable key, IBTreeNodeOneValuePerKey node) {
        if (!on) {
            return false;
        }
        for (int i = 0; i < node.getNbKeys(); ++i) {
            if (node.getKeyAndValueAt(i).getKey().compareTo(key) != 0) continue;
            return true;
        }
        return false;
    }
}

