/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts;

public class LanguageCode {
    private int code;
    private String name;

    public LanguageCode(String name, int code) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.name = name;
        this.code = code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageCode language = (LanguageCode)o;
        return this.code == language.code;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.code;
    }

    public static class MacLanguageCode
    extends LanguageCode {
        public static final LanguageCode ENGLISH = new LanguageCode("english", 0);

        public MacLanguageCode(String name, int code) {
            super(name, code);
        }
    }

    public static class MicrosoftLanguageCode
    extends LanguageCode {
        public static final LanguageCode ENGLISH_US = new LanguageCode("en_US", 1033);

        public MicrosoftLanguageCode(String name, int code) {
            super(name, code);
        }
    }
}

