/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.ejml.UtilEjml;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.MatrixIterator64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.factory.SingularMatrixException;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.MatrixIO;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public abstract class SimpleBase<T extends SimpleBase>
implements Serializable {
    protected DenseMatrix64F mat;

    public SimpleBase(int n, int n2) {
        this.mat = new DenseMatrix64F(n, n2);
    }

    protected SimpleBase() {
    }

    protected abstract T createMatrix(int var1, int var2);

    public DenseMatrix64F getMatrix() {
        return this.mat;
    }

    public T transpose() {
        T t = this.createMatrix(this.mat.numCols, this.mat.numRows);
        CommonOps.transpose(this.mat, ((SimpleBase)t).getMatrix());
        return t;
    }

    public T mult(T t) {
        T t2 = this.createMatrix(this.mat.numRows, ((SimpleBase)t).getMatrix().numCols);
        CommonOps.mult(this.mat, ((SimpleBase)t).getMatrix(), ((SimpleBase)t2).getMatrix());
        return t2;
    }

    public T kron(T t) {
        T t2 = this.createMatrix(this.mat.numRows * ((SimpleBase)t).numRows(), this.mat.numCols * ((SimpleBase)t).numCols());
        CommonOps.kron(this.mat, ((SimpleBase)t).getMatrix(), ((SimpleBase)t2).getMatrix());
        return t2;
    }

    public T plus(T t) {
        T t2 = this.copy();
        CommonOps.addEquals(((SimpleBase)t2).getMatrix(), ((SimpleBase)t).getMatrix());
        return t2;
    }

    public T minus(T t) {
        T t2 = this.copy();
        CommonOps.subtract((D1Matrix64F)this.getMatrix(), (D1Matrix64F)((SimpleBase)t).getMatrix(), (D1Matrix64F)((SimpleBase)t2).getMatrix());
        return t2;
    }

    public T minus(double d) {
        T t = this.copy();
        CommonOps.subtract((D1Matrix64F)this.getMatrix(), d, (D1Matrix64F)((SimpleBase)t).getMatrix());
        return t;
    }

    public T plus(double d) {
        T t = this.createMatrix(this.numRows(), this.numCols());
        CommonOps.add((D1Matrix64F)this.getMatrix(), d, (D1Matrix64F)((SimpleBase)t).getMatrix());
        return t;
    }

    public T plus(double d, T t) {
        T t2 = this.copy();
        CommonOps.addEquals(((SimpleBase)t2).getMatrix(), d, ((SimpleBase)t).getMatrix());
        return t2;
    }

    public double dot(T t) {
        if (!this.isVector()) {
            throw new IllegalArgumentException("'this' matrix is not a vector.");
        }
        if (!((SimpleBase)t).isVector()) {
            throw new IllegalArgumentException("'v' matrix is not a vector.");
        }
        return VectorVectorMult.innerProd(this.mat, ((SimpleBase)t).getMatrix());
    }

    public boolean isVector() {
        return this.mat.numRows == 1 || this.mat.numCols == 1;
    }

    public T scale(double d) {
        T t = this.copy();
        CommonOps.scale(d, ((SimpleBase)t).getMatrix());
        return t;
    }

    public T divide(double d) {
        T t = this.copy();
        CommonOps.divide(((SimpleBase)t).getMatrix(), d);
        return t;
    }

    public T invert() {
        T t = this.createMatrix(this.mat.numRows, this.mat.numCols);
        if (!CommonOps.invert(this.mat, ((SimpleBase)t).getMatrix())) {
            throw new SingularMatrixException();
        }
        if (MatrixFeatures.hasUncountable(((SimpleBase)t).getMatrix())) {
            throw new SingularMatrixException("Solution has uncountable numbers");
        }
        return t;
    }

    public T pseudoInverse() {
        T t = this.createMatrix(this.mat.numCols, this.mat.numRows);
        CommonOps.pinv(this.mat, ((SimpleBase)t).getMatrix());
        return t;
    }

    public T solve(T t) {
        T t2 = this.createMatrix(this.mat.numCols, ((SimpleBase)t).getMatrix().numCols);
        if (!CommonOps.solve(this.mat, ((SimpleBase)t).getMatrix(), ((SimpleBase)t2).getMatrix())) {
            throw new SingularMatrixException();
        }
        if (MatrixFeatures.hasUncountable(((SimpleBase)t2).getMatrix())) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return t2;
    }

    public void set(T t) {
        this.mat.set(((SimpleBase)t).getMatrix());
    }

    public void set(double d) {
        CommonOps.fill(this.mat, d);
    }

    public void zero() {
        this.mat.zero();
    }

    public double normF() {
        return NormOps.normF(this.mat);
    }

    public double conditionP2() {
        return NormOps.conditionP2(this.mat);
    }

    public double determinant() {
        double d = CommonOps.det(this.mat);
        if (UtilEjml.isUncountable(d)) {
            return 0.0;
        }
        return d;
    }

    public double trace() {
        return CommonOps.trace(this.mat);
    }

    public void reshape(int n, int n2) {
        this.mat.reshape(n, n2, false);
    }

    public void set(int n, int n2, double d) {
        this.mat.set(n, n2, d);
    }

    public void set(int n, double d) {
        this.mat.set(n, d);
    }

    public void setRow(int n, int n2, double ... dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.mat.set(n, n2 + i, dArray[i]);
        }
    }

    public void setColumn(int n, int n2, double ... dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.mat.set(n2 + i, n, dArray[i]);
        }
    }

    public double get(int n, int n2) {
        return this.mat.get(n, n2);
    }

    public double get(int n) {
        return this.mat.data[n];
    }

    public int getIndex(int n, int n2) {
        return n * this.mat.numCols + n2;
    }

    public MatrixIterator64F iterator(boolean bl, int n, int n2, int n3, int n4) {
        return new MatrixIterator64F(this.mat, bl, n, n2, n3, n4);
    }

    public T copy() {
        T t = this.createMatrix(this.mat.numRows, this.mat.numCols);
        ((SimpleBase)t).getMatrix().set(this.getMatrix());
        return t;
    }

    public int numRows() {
        return this.mat.numRows;
    }

    public int numCols() {
        return this.mat.numCols;
    }

    public int getNumElements() {
        return this.mat.getNumElements();
    }

    public void print() {
        MatrixIO.print(System.out, this.mat);
    }

    public void print(int n, int n2) {
        MatrixIO.print(System.out, this.mat, n, n2);
    }

    public void print(String string) {
        MatrixIO.print(System.out, this.mat, string);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MatrixIO.print(new PrintStream(byteArrayOutputStream), this.mat);
        return byteArrayOutputStream.toString();
    }

    public T extractMatrix(int n, int n2, int n3, int n4) {
        if (n == Integer.MAX_VALUE) {
            n = this.mat.numRows;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.mat.numRows;
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = this.mat.numCols;
        }
        if (n4 == Integer.MAX_VALUE) {
            n4 = this.mat.numCols;
        }
        T t = this.createMatrix(n2 - n, n4 - n3);
        CommonOps.extract(this.mat, n, n2, n3, n4, ((SimpleBase)t).getMatrix(), 0, 0);
        return t;
    }

    public T extractVector(boolean bl, int n) {
        T t;
        int n2 = bl ? this.mat.numCols : this.mat.numRows;
        T t2 = t = bl ? this.createMatrix(1, n2) : this.createMatrix(n2, 1);
        if (bl) {
            SpecializedOps.subvector(this.mat, n, 0, n2, true, 0, ((SimpleBase)t).getMatrix());
        } else {
            SpecializedOps.subvector(this.mat, 0, n, n2, false, 0, ((SimpleBase)t).getMatrix());
        }
        return t;
    }

    public T extractDiag() {
        int n = Math.min(this.mat.numCols, this.mat.numRows);
        T t = this.createMatrix(n, 1);
        CommonOps.extractDiag(this.mat, ((SimpleBase)t).getMatrix());
        return t;
    }

    public boolean isIdentical(T t, double d) {
        return MatrixFeatures.isIdentical(this.mat, ((SimpleBase)t).getMatrix(), d);
    }

    public boolean hasUncountable() {
        return MatrixFeatures.hasUncountable(this.mat);
    }

    public SimpleSVD svd() {
        return new SimpleSVD(this.mat, false);
    }

    public SimpleSVD svd(boolean bl) {
        return new SimpleSVD(this.mat, bl);
    }

    public SimpleEVD eig() {
        return new SimpleEVD(this.mat);
    }

    public void insertIntoThis(int n, int n2, T t) {
        CommonOps.insert(((SimpleBase)t).getMatrix(), this.mat, n, n2);
    }

    public T combine(int n, int n2, T t) {
        SimpleBase<T> simpleBase;
        if (n == Integer.MAX_VALUE) {
            n = this.mat.numRows;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.mat.numCols;
        }
        int n3 = n + ((SimpleBase)t).numRows();
        int n4 = n2 + ((SimpleBase)t).numCols();
        if (n3 > this.mat.numRows || n4 > this.mat.numCols) {
            int n5 = Math.max(n3, this.mat.numRows);
            int n6 = Math.max(n4, this.mat.numCols);
            simpleBase = this.createMatrix(n5, n6);
            simpleBase.insertIntoThis(0, 0, (SimpleBase)this);
        } else {
            simpleBase = this.copy();
        }
        simpleBase.insertIntoThis(n, n2, t);
        return (T)simpleBase;
    }

    public double elementMaxAbs() {
        return CommonOps.elementMaxAbs(this.mat);
    }

    public double elementSum() {
        return CommonOps.elementSum(this.mat);
    }

    public T elementMult(T t) {
        T t2 = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementMult(this.mat, ((SimpleBase)t).getMatrix(), ((SimpleBase)t2).getMatrix());
        return t2;
    }

    public T elementDiv(T t) {
        T t2 = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementDiv(this.mat, ((SimpleBase)t).getMatrix(), ((SimpleBase)t2).getMatrix());
        return t2;
    }

    public T elementPower(T t) {
        T t2 = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementPower((D1Matrix64F)this.mat, (D1Matrix64F)((SimpleBase)t).getMatrix(), (D1Matrix64F)((SimpleBase)t2).getMatrix());
        return t2;
    }

    public T elementPower(double d) {
        T t = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementPower((D1Matrix64F)this.mat, d, (D1Matrix64F)((SimpleBase)t).getMatrix());
        return t;
    }

    public T elementExp() {
        T t = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementExp(this.mat, ((SimpleBase)t).getMatrix());
        return t;
    }

    public T elementLog() {
        T t = this.createMatrix(this.mat.numRows, this.mat.numCols);
        CommonOps.elementLog(this.mat, ((SimpleBase)t).getMatrix());
        return t;
    }

    public T negative() {
        T t = this.copy();
        CommonOps.changeSign(((SimpleBase)t).getMatrix());
        return t;
    }

    public void saveToFileBinary(String string) throws IOException {
        MatrixIO.saveBin(this.mat, string);
    }

    public static SimpleMatrix loadBinary(String string) throws IOException {
        Object t = MatrixIO.loadBin(string);
        if (t instanceof DenseMatrix64F) {
            return SimpleMatrix.wrap((DenseMatrix64F)t);
        }
        return SimpleMatrix.wrap(new DenseMatrix64F((RealMatrix64F)t));
    }

    public void saveToFileCSV(String string) throws IOException {
        MatrixIO.saveCSV(this.mat, string);
    }

    public T loadCSV(String string) throws IOException {
        DenseMatrix64F denseMatrix64F = MatrixIO.loadCSV(string);
        T t = this.createMatrix(1, 1);
        ((SimpleBase)t).mat = denseMatrix64F instanceof DenseMatrix64F ? denseMatrix64F : new DenseMatrix64F((RealMatrix64F)denseMatrix64F);
        return t;
    }

    public boolean isInBounds(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.mat.numRows && n2 < this.mat.numCols;
    }

    public void printDimensions() {
        System.out.println("[rows = " + this.numRows() + " , cols = " + this.numCols() + " ]");
    }
}

