/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.NormOps;

public class SpecializedOps {
    public static DenseMatrix64F createReflector(RowD1Matrix64F rowD1Matrix64F) {
        if (!MatrixFeatures.isVector(rowD1Matrix64F)) {
            throw new IllegalArgumentException("u must be a vector");
        }
        double d = NormOps.fastNormF(rowD1Matrix64F);
        double d2 = -2.0 / (d * d);
        DenseMatrix64F denseMatrix64F = CommonOps.identity(rowD1Matrix64F.getNumElements());
        CommonOps.multAddTransB(d2, rowD1Matrix64F, rowD1Matrix64F, denseMatrix64F);
        return denseMatrix64F;
    }

    public static DenseMatrix64F createReflector(DenseMatrix64F denseMatrix64F, double d) {
        if (!MatrixFeatures.isVector(denseMatrix64F)) {
            throw new IllegalArgumentException("u must be a vector");
        }
        DenseMatrix64F denseMatrix64F2 = CommonOps.identity(denseMatrix64F.getNumElements());
        CommonOps.multAddTransB(-d, denseMatrix64F, denseMatrix64F, denseMatrix64F2);
        return denseMatrix64F2;
    }

    public static DenseMatrix64F copyChangeRow(int[] nArray, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2 == null) {
            denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols);
        } else if (denseMatrix64F.numRows != denseMatrix64F2.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("src and dst must have the same dimensions.");
        }
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            int n = i * denseMatrix64F.numCols;
            int n2 = nArray[i] * denseMatrix64F.numCols;
            System.arraycopy(denseMatrix64F.data, n2, denseMatrix64F2.data, n, denseMatrix64F.numCols);
        }
        return denseMatrix64F2;
    }

    public static DenseMatrix64F copyTriangle(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, boolean bl) {
        if (denseMatrix64F2 == null) {
            denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols);
        } else if (denseMatrix64F.numRows != denseMatrix64F2.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("src and dst must have the same dimensions.");
        }
        if (bl) {
            int n = Math.min(denseMatrix64F.numRows, denseMatrix64F.numCols);
            for (int i = 0; i < n; ++i) {
                int n2 = i * denseMatrix64F.numCols + i;
                System.arraycopy(denseMatrix64F.data, n2, denseMatrix64F2.data, n2, denseMatrix64F.numCols - i);
            }
        } else {
            for (int i = 0; i < denseMatrix64F.numRows; ++i) {
                int n = Math.min(i + 1, denseMatrix64F.numCols);
                int n3 = i * denseMatrix64F.numCols;
                System.arraycopy(denseMatrix64F.data, n3, denseMatrix64F2.data, n3, n);
            }
        }
        return denseMatrix64F2;
    }

    public static double diffNormF(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Both matrices must have the same shape.");
        }
        int n = d1Matrix64F.getNumElements();
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, 1);
        for (int i = 0; i < n; ++i) {
            denseMatrix64F.set(i, d1Matrix64F2.get(i) - d1Matrix64F.get(i));
        }
        return NormOps.normF(denseMatrix64F);
    }

    public static double diffNormF_fast(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Both matrices must have the same shape.");
        }
        int n = d1Matrix64F.getNumElements();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = d1Matrix64F2.get(i) - d1Matrix64F.get(i);
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double diffNormP1(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Both matrices must have the same shape.");
        }
        int n = d1Matrix64F.getNumElements();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.abs(d1Matrix64F2.get(i) - d1Matrix64F.get(i));
        }
        return d;
    }

    public static void addIdentity(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, double d) {
        if (rowD1Matrix64F.numCols != rowD1Matrix64F.numRows) {
            throw new IllegalArgumentException("A must be square");
        }
        if (rowD1Matrix64F2.numCols != rowD1Matrix64F.numCols || rowD1Matrix64F2.numRows != rowD1Matrix64F.numRows) {
            throw new IllegalArgumentException("B must be the same shape as A");
        }
        int n = rowD1Matrix64F.numCols;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            while (n3 < n) {
                if (i == n3) {
                    rowD1Matrix64F2.set(n2, rowD1Matrix64F.get(n2) + d);
                } else {
                    rowD1Matrix64F2.set(n2, rowD1Matrix64F.get(n2));
                }
                ++n3;
                ++n2;
            }
        }
    }

    public static void subvector(RowD1Matrix64F rowD1Matrix64F, int n, int n2, int n3, boolean bl, int n4, RowD1Matrix64F rowD1Matrix64F2) {
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                rowD1Matrix64F2.set(n4 + i, rowD1Matrix64F.get(n, n2 + i));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                rowD1Matrix64F2.set(n4 + i, rowD1Matrix64F.get(n + i, n2));
            }
        }
    }

    public static DenseMatrix64F[] splitIntoVectors(RowD1Matrix64F rowD1Matrix64F, boolean bl) {
        int n = bl ? rowD1Matrix64F.numCols : rowD1Matrix64F.numRows;
        int n2 = bl ? rowD1Matrix64F.numRows : 1;
        int n3 = bl ? 1 : rowD1Matrix64F.numCols;
        int n4 = Math.max(n2, n3);
        DenseMatrix64F[] denseMatrix64FArray = new DenseMatrix64F[n];
        for (int i = 0; i < n; ++i) {
            DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n2, n3);
            if (bl) {
                SpecializedOps.subvector(rowD1Matrix64F, 0, i, n4, false, 0, denseMatrix64F);
            } else {
                SpecializedOps.subvector(rowD1Matrix64F, i, 0, n4, true, 0, denseMatrix64F);
            }
            denseMatrix64FArray[i] = denseMatrix64F;
        }
        return denseMatrix64FArray;
    }

    public static DenseMatrix64F pivotMatrix(DenseMatrix64F denseMatrix64F, int[] nArray, int n, boolean bl) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n, n);
        } else {
            if (denseMatrix64F.numCols != n || denseMatrix64F.numRows != n) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CommonOps.fill(denseMatrix64F, 0.0);
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                denseMatrix64F.set(nArray[i], i, 1.0);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                denseMatrix64F.set(i, nArray[i], 1.0);
            }
        }
        return denseMatrix64F;
    }

    public static double diagProd(RowD1Matrix64F rowD1Matrix64F) {
        double d = 1.0;
        int n = Math.min(rowD1Matrix64F.numRows, rowD1Matrix64F.numCols);
        for (int i = 0; i < n; ++i) {
            d *= rowD1Matrix64F.unsafe_get(i, i);
        }
        return d;
    }

    public static double elementDiagonalMaxAbs(D1Matrix64F d1Matrix64F) {
        int n = Math.min(d1Matrix64F.numRows, d1Matrix64F.numCols);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(d1Matrix64F.get(i, i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double qualityTriangular(D1Matrix64F d1Matrix64F) {
        int n = Math.min(d1Matrix64F.numRows, d1Matrix64F.numCols);
        double d = SpecializedOps.elementDiagonalMaxAbs(d1Matrix64F);
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            d2 *= d1Matrix64F.unsafe_get(i, i) / d;
        }
        return Math.abs(d2);
    }

    public static double elementSumSq(D1Matrix64F d1Matrix64F) {
        double d = 0.0;
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d2 = d1Matrix64F.data[i];
            d += d2 * d2;
        }
        return d;
    }
}

