/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.ops.ReadCsv;

public class ReadMatrixCsv
extends ReadCsv {
    public ReadMatrixCsv(InputStream inputStream) {
        super(inputStream);
    }

    public <M extends Matrix> M read() throws IOException {
        boolean bl;
        List<String> list = this.extractWords();
        if (list.size() != 3) {
            throw new IOException("Unexpected number of words on first line.");
        }
        int n = Integer.parseInt(list.get(0));
        int n2 = Integer.parseInt(list.get(1));
        boolean bl2 = bl = list.get(2).compareToIgnoreCase("real") == 0;
        if (n < 0 || n2 < 0) {
            throw new IOException("Invalid number of rows and/or columns: " + n + " " + n2);
        }
        if (bl) {
            return (M)this.readReal(n, n2);
        }
        return (M)this.readComplex(n, n2);
    }

    public DenseMatrix64F readReal(int n, int n2) throws IOException {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        for (int i = 0; i < n; ++i) {
            List<String> list = this.extractWords();
            if (list == null) {
                throw new IOException("Too few rows found. expected " + n + " actual " + i);
            }
            if (list.size() != n2) {
                throw new IOException("Unexpected number of words in column. Found " + list.size() + " expected " + n2);
            }
            for (int j = 0; j < n2; ++j) {
                denseMatrix64F.set(i, j, Double.parseDouble(list.get(j)));
            }
        }
        return denseMatrix64F;
    }

    public CDenseMatrix64F readComplex(int n, int n2) throws IOException {
        CDenseMatrix64F cDenseMatrix64F = new CDenseMatrix64F(n, n2);
        int n3 = n2 * 2;
        for (int i = 0; i < n; ++i) {
            List<String> list = this.extractWords();
            if (list == null) {
                throw new IOException("Too few rows found. expected " + n + " actual " + i);
            }
            if (list.size() != n3) {
                throw new IOException("Unexpected number of words in column. Found " + list.size() + " expected " + n3);
            }
            for (int j = 0; j < n3; j += 2) {
                double d = Double.parseDouble(list.get(j));
                double d2 = Double.parseDouble(list.get(j + 1));
                cDenseMatrix64F.set(i, j, d, d2);
            }
        }
        return cDenseMatrix64F;
    }
}

