/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.alg.dense.mult.SubmatrixOps;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;

public class RandomMatrices {
    public static DenseMatrix64F[] createSpan(int n, int n2, Random random) {
        if (n < n2) {
            throw new IllegalArgumentException("The number of vectors must be less than or equal to the dimension");
        }
        DenseMatrix64F[] denseMatrix64FArray = new DenseMatrix64F[n2];
        denseMatrix64FArray[0] = RandomMatrices.createRandom(n, 1, -1.0, 1.0, random);
        NormOps.normalizeF(denseMatrix64FArray[0]);
        for (int i = 1; i < n2; ++i) {
            DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, 1);
            DenseMatrix64F denseMatrix64F2 = null;
            for (int j = 0; j < i; ++j) {
                if (j == 0) {
                    denseMatrix64F2 = RandomMatrices.createRandom(n, 1, -1.0, 1.0, random);
                }
                denseMatrix64F.set(denseMatrix64F2);
                VectorVectorMult.householder(-2.0, denseMatrix64FArray[j], denseMatrix64F2, denseMatrix64F);
                CommonOps.add((D1Matrix64F)denseMatrix64F2, denseMatrix64F, (D1Matrix64F)denseMatrix64F);
                CommonOps.scale(0.5, denseMatrix64F);
                DenseMatrix64F denseMatrix64F3 = denseMatrix64F;
                denseMatrix64F = denseMatrix64F2;
                denseMatrix64F2 = denseMatrix64F3;
                double d = NormOps.normF(denseMatrix64F2);
                if (d == 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
                    throw new RuntimeException("Failed sanity check");
                }
                CommonOps.divide(denseMatrix64F2, d);
            }
            denseMatrix64FArray[i] = denseMatrix64F2;
        }
        return denseMatrix64FArray;
    }

    public static DenseMatrix64F createInSpan(DenseMatrix64F[] denseMatrix64FArray, double d, double d2, Random random) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(denseMatrix64FArray.length, 1);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(denseMatrix64FArray[0].getNumElements(), 1);
        for (int i = 0; i < denseMatrix64FArray.length; ++i) {
            denseMatrix64F2.set(denseMatrix64FArray[i]);
            double d3 = random.nextDouble() * (d2 - d) + d;
            CommonOps.scale(d3, denseMatrix64F2);
            CommonOps.add((D1Matrix64F)denseMatrix64F, denseMatrix64F2, (D1Matrix64F)denseMatrix64F);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F createOrthogonal(int n, int n2, Random random) {
        if (n < n2) {
            throw new IllegalArgumentException("The number of rows must be more than or equal to the number of columns");
        }
        DenseMatrix64F[] denseMatrix64FArray = RandomMatrices.createSpan(n, n2, random);
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        for (int i = 0; i < n2; ++i) {
            SubmatrixOps.setSubMatrix(denseMatrix64FArray[i], denseMatrix64F, 0, 0, 0, i, n, 1);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F createDiagonal(int n, double d, double d2, Random random) {
        return RandomMatrices.createDiagonal(n, n, d, d2, random);
    }

    public static DenseMatrix64F createDiagonal(int n, int n2, double d, double d2, Random random) {
        if (d2 < d) {
            throw new IllegalArgumentException("The max must be >= the min");
        }
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        int n3 = Math.min(n, n2);
        double d3 = d2 - d;
        for (int i = 0; i < n3; ++i) {
            denseMatrix64F.set(i, i, random.nextDouble() * d3 + d);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F createSingularValues(int n, int n2, Random random, double ... dArray) {
        DenseMatrix64F denseMatrix64F = RandomMatrices.createOrthogonal(n, n, random);
        DenseMatrix64F denseMatrix64F2 = RandomMatrices.createOrthogonal(n2, n2, random);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, n2);
        int n3 = Math.min(n, n2);
        n3 = Math.min(n3, dArray.length);
        for (int i = 0; i < n3; ++i) {
            denseMatrix64F3.set(i, i, dArray[i]);
        }
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(n, n2);
        CommonOps.mult(denseMatrix64F, denseMatrix64F3, denseMatrix64F4);
        CommonOps.multTransB(denseMatrix64F4, denseMatrix64F2, denseMatrix64F3);
        return denseMatrix64F3;
    }

    public static DenseMatrix64F createEigenvaluesSymm(int n, Random random, double ... dArray) {
        DenseMatrix64F denseMatrix64F = RandomMatrices.createOrthogonal(n, n, random);
        DenseMatrix64F denseMatrix64F2 = CommonOps.diag(dArray);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, n);
        CommonOps.mult(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        CommonOps.multTransB(denseMatrix64F3, denseMatrix64F, denseMatrix64F2);
        return denseMatrix64F2;
    }

    public static DenseMatrix64F createRandom(int n, int n2, Random random) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        RandomMatrices.setRandom(denseMatrix64F, 0.0, 1.0, random);
        return denseMatrix64F;
    }

    public static void addRandom(DenseMatrix64F denseMatrix64F, double d, double d2, Random random) {
        double[] dArray = denseMatrix64F.getData();
        int n = denseMatrix64F.getNumElements();
        double d3 = d2 - d;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] + (d3 * random.nextDouble() + d);
        }
    }

    public static DenseMatrix64F createRandom(int n, int n2, double d, double d2, Random random) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        RandomMatrices.setRandom(denseMatrix64F, d, d2, random);
        return denseMatrix64F;
    }

    public static void setRandom(DenseMatrix64F denseMatrix64F, Random random) {
        RandomMatrices.setRandom(denseMatrix64F, 0.0, 1.0, random);
    }

    public static void setRandom(D1Matrix64F d1Matrix64F, double d, double d2, Random random) {
        double[] dArray = d1Matrix64F.getData();
        int n = d1Matrix64F.getNumElements();
        double d3 = d2 - d;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d3 * random.nextDouble() + d;
        }
    }

    public static DenseMatrix64F createGaussian(int n, int n2, double d, double d2, Random random) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        RandomMatrices.setGaussian(denseMatrix64F, d, d2, random);
        return denseMatrix64F;
    }

    public static void setGaussian(D1Matrix64F d1Matrix64F, double d, double d2, Random random) {
        double[] dArray = d1Matrix64F.getData();
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + d2 * random.nextGaussian();
        }
    }

    public static DenseMatrix64F createSymmPosDef(int n, Random random) {
        int n2;
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, 1);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n, n);
        for (n2 = 0; n2 < n; ++n2) {
            denseMatrix64F.set(n2, 0, random.nextDouble());
        }
        CommonOps.multTransB(denseMatrix64F, denseMatrix64F, denseMatrix64F2);
        for (n2 = 0; n2 < n; ++n2) {
            denseMatrix64F2.add(n2, n2, 1.0);
        }
        return denseMatrix64F2;
    }

    public static DenseMatrix64F createSymmetric(int n, double d, double d2, Random random) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n);
        RandomMatrices.createSymmetric(denseMatrix64F, d, d2, random);
        return denseMatrix64F;
    }

    public static void createSymmetric(DenseMatrix64F denseMatrix64F, double d, double d2, Random random) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("A must be a square matrix");
        }
        double d3 = d2 - d;
        int n = denseMatrix64F.numRows;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d4 = random.nextDouble() * d3 + d;
                denseMatrix64F.set(i, j, d4);
                denseMatrix64F.set(j, i, d4);
            }
        }
    }

    public static DenseMatrix64F createUpperTriangle(int n, int n2, double d, double d2, Random random) {
        if (n2 < 0) {
            throw new RuntimeException("hessenberg must be more than or equal to 0");
        }
        double d3 = d2 - d;
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n);
        for (int i = 0; i < n; ++i) {
            int n3;
            for (int j = n3 = i <= n2 ? 0 : i - n2; j < n; ++j) {
                denseMatrix64F.set(i, j, random.nextDouble() * d3 + d);
            }
        }
        return denseMatrix64F;
    }
}

