/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class MatrixFeatures {
    public static boolean hasNaN(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(d1Matrix64F.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUncountable(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d = d1Matrix64F.get(i);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZeros(D1Matrix64F d1Matrix64F, double d) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(d1Matrix64F.get(i)) > d)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVector(Matrix matrix) {
        return matrix.getNumCols() == 1 || matrix.getNumRows() == 1;
    }

    public static boolean isPositiveDefinite(DenseMatrix64F denseMatrix64F) {
        if (!MatrixFeatures.isSquare(denseMatrix64F)) {
            return false;
        }
        CholeskyDecompositionInner_D64 choleskyDecompositionInner_D64 = new CholeskyDecompositionInner_D64(true);
        if (choleskyDecompositionInner_D64.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        return choleskyDecompositionInner_D64.decompose(denseMatrix64F);
    }

    public static boolean isPositiveSemidefinite(DenseMatrix64F denseMatrix64F) {
        if (!MatrixFeatures.isSquare(denseMatrix64F)) {
            return false;
        }
        EigenDecomposition<DenseMatrix64F> eigenDecomposition = DecompositionFactory.eig(denseMatrix64F.numCols, false);
        if (eigenDecomposition.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        eigenDecomposition.decompose(denseMatrix64F);
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            Complex64F complex64F = eigenDecomposition.getEigenvalue(i);
            if (!(complex64F.getReal() < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(D1Matrix64F d1Matrix64F) {
        return d1Matrix64F.numCols == d1Matrix64F.numRows;
    }

    public static boolean isSymmetric(DenseMatrix64F denseMatrix64F, double d) {
        if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
            return false;
        }
        double d2 = CommonOps.elementMaxAbs(denseMatrix64F);
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < i; ++j) {
                double d3;
                double d4 = denseMatrix64F.get(i, j) / d2;
                double d5 = Math.abs(d4 - (d3 = denseMatrix64F.get(j, i) / d2));
                if (d5 <= d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSymmetric(DenseMatrix64F denseMatrix64F) {
        return MatrixFeatures.isSymmetric(denseMatrix64F, 0.0);
    }

    public static boolean isSkewSymmetric(DenseMatrix64F denseMatrix64F, double d) {
        if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
            return false;
        }
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < i; ++j) {
                double d2;
                double d3 = denseMatrix64F.get(i, j);
                double d4 = Math.abs(d3 + (d2 = denseMatrix64F.get(j, i)));
                if (d4 <= d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isInverse(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, double d) {
        if (denseMatrix64F.numRows != denseMatrix64F2.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            return false;
        }
        int n = denseMatrix64F.numRows;
        int n2 = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d2 += denseMatrix64F.get(i, k) * denseMatrix64F2.get(k, j);
                }
                if (!(i == j ? !(Math.abs(d2 - 1.0) <= d) : !(Math.abs(d2) <= d))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEquals(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, double d) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            return false;
        }
        if (d == 0.0) {
            return MatrixFeatures.isEquals(d1Matrix64F, d1Matrix64F2);
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (d >= Math.abs(d1Matrix64F.get(i) - d1Matrix64F2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualsTriangle(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2, boolean bl, double d) {
        if (realMatrix64F.getNumRows() != realMatrix64F2.getNumRows() || realMatrix64F.getNumCols() != realMatrix64F2.getNumCols()) {
            return false;
        }
        if (bl) {
            for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
                for (int j = i; j < realMatrix64F.getNumCols(); ++j) {
                    if (!(Math.abs(realMatrix64F.get(i, j) - realMatrix64F2.get(i, j)) > d)) continue;
                    return false;
                }
            }
        } else {
            for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
                int n = Math.min(i, realMatrix64F.getNumCols() - 1);
                for (int j = 0; j <= n; ++j) {
                    if (!(Math.abs(realMatrix64F.get(i, j) - realMatrix64F2.get(i, j)) > d)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEquals(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            return false;
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (d1Matrix64F.get(i) == d1Matrix64F2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentical(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, double d) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            return false;
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero.");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = d1Matrix64F.get(i);
            double d4 = Math.abs(d3 - (d2 = d1Matrix64F2.get(i)));
            if (d >= d4) continue;
            if (Double.isNaN(d3)) {
                return Double.isNaN(d2);
            }
            if (Double.isInfinite(d3)) {
                return d3 == d2;
            }
            return false;
        }
        return true;
    }

    public static boolean isOrthogonal(DenseMatrix64F denseMatrix64F, double d) {
        if (denseMatrix64F.numRows < denseMatrix64F.numCols) {
            throw new IllegalArgumentException("The number of rows must be more than or equal to the number of columns");
        }
        DenseMatrix64F[] denseMatrix64FArray = CommonOps.columnsToVector(denseMatrix64F, null);
        for (int i = 0; i < denseMatrix64FArray.length; ++i) {
            DenseMatrix64F denseMatrix64F2 = denseMatrix64FArray[i];
            for (int j = i + 1; j < denseMatrix64FArray.length; ++j) {
                double d2 = VectorVectorMult.innerProd(denseMatrix64F2, denseMatrix64FArray[j]);
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isRowsLinearIndependent(DenseMatrix64F denseMatrix64F) {
        LUDecomposition<DenseMatrix64F> lUDecomposition = DecompositionFactory.lu(denseMatrix64F.numRows, denseMatrix64F.numCols);
        if (lUDecomposition.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        if (!lUDecomposition.decompose(denseMatrix64F)) {
            throw new RuntimeException("Decompositon failed?");
        }
        return !lUDecomposition.isSingular();
    }

    public static boolean isIdentity(DenseMatrix64F denseMatrix64F, double d) {
        int n = 0;
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < denseMatrix64F.numCols; ++j) {
                if (!(i == j ? !(Math.abs(denseMatrix64F.get(n++) - 1.0) <= d) : !(Math.abs(denseMatrix64F.get(n++)) <= d))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isConstantVal(DenseMatrix64F denseMatrix64F, double d, double d2) {
        int n = 0;
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < denseMatrix64F.numCols; ++j) {
                if (Math.abs(denseMatrix64F.get(n++) - d) <= d2) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDiagonalPositive(DenseMatrix64F denseMatrix64F) {
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            if (denseMatrix64F.get(i, i) >= 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullRank(DenseMatrix64F denseMatrix64F) {
        throw new RuntimeException("Implement");
    }

    public static boolean isNegative(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, double d) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Matrix dimensions must match");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (Math.abs(d1Matrix64F.get(i) + d1Matrix64F2.get(i)) <= d) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperTriangle(DenseMatrix64F denseMatrix64F, int n, double d) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            return false;
        }
        for (int i = n + 1; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < i - n; ++j) {
                if (Math.abs(denseMatrix64F.get(i, j)) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public static int rank(DenseMatrix64F denseMatrix64F) {
        return MatrixFeatures.rank(denseMatrix64F, UtilEjml.EPS * 100.0);
    }

    public static int rank(DenseMatrix64F denseMatrix64F, double d) {
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(denseMatrix64F.numRows, denseMatrix64F.numCols, false, false, true);
        if (singularValueDecomposition.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        if (!singularValueDecomposition.decompose(denseMatrix64F)) {
            throw new RuntimeException("Decomposition failed");
        }
        return SingularOps.rank(singularValueDecomposition, d);
    }

    public static int nullity(DenseMatrix64F denseMatrix64F) {
        return MatrixFeatures.nullity(denseMatrix64F, UtilEjml.EPS * 100.0);
    }

    public static int nullity(DenseMatrix64F denseMatrix64F, double d) {
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(denseMatrix64F.numRows, denseMatrix64F.numCols, false, false, true);
        if (singularValueDecomposition.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        if (!singularValueDecomposition.decompose(denseMatrix64F)) {
            throw new RuntimeException("Decomposition failed");
        }
        return SingularOps.nullity(singularValueDecomposition, d);
    }
}

