/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class CovarianceRandomDraw {
    private DenseMatrix64F A;
    private Random rand;
    private DenseMatrix64F r;

    public CovarianceRandomDraw(Random random, DenseMatrix64F denseMatrix64F) {
        this.r = new DenseMatrix64F(denseMatrix64F.numRows, 1);
        CholeskyDecompositionInner_D64 choleskyDecompositionInner_D64 = new CholeskyDecompositionInner_D64(true);
        if (choleskyDecompositionInner_D64.inputModified()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        if (!choleskyDecompositionInner_D64.decompose(denseMatrix64F)) {
            throw new RuntimeException("Decomposition failed!");
        }
        this.A = choleskyDecompositionInner_D64.getT();
        this.rand = random;
    }

    public void next(DenseMatrix64F denseMatrix64F) {
        for (int i = 0; i < this.r.numRows; ++i) {
            this.r.set(i, 0, this.rand.nextGaussian());
        }
        CommonOps.multAdd(this.A, this.r, denseMatrix64F);
    }

    public double computeLikelihoodP() {
        double d = 1.0;
        for (int i = 0; i < this.r.numRows; ++i) {
            double d2 = this.r.get(i, 0);
            d *= Math.exp(-d2 * d2 / 2.0);
        }
        return d;
    }
}

