/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.FixedMatrix2_64F;
import org.ejml.data.FixedMatrix2x2_64F;
import org.ejml.data.FixedMatrix3_64F;
import org.ejml.data.FixedMatrix3x3_64F;
import org.ejml.data.FixedMatrix4_64F;
import org.ejml.data.FixedMatrix4x4_64F;
import org.ejml.data.FixedMatrix5_64F;
import org.ejml.data.FixedMatrix5x5_64F;
import org.ejml.data.FixedMatrix6_64F;
import org.ejml.data.FixedMatrix6x6_64F;
import org.ejml.data.RealMatrix64F;

public class ConvertMatrixType {
    public static void convert(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2) {
        if (realMatrix64F.getNumRows() != realMatrix64F2.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (realMatrix64F.getNumCols() != realMatrix64F2.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                realMatrix64F2.unsafe_set(i, j, realMatrix64F.unsafe_get(i, j));
            }
        }
    }

    public static DenseMatrix64F convert(FixedMatrix2x2_64F fixedMatrix2x2_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(2, 2);
        }
        if (fixedMatrix2x2_64F.getNumRows() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (fixedMatrix2x2_64F.getNumCols() != denseMatrix64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        denseMatrix64F.data[0] = fixedMatrix2x2_64F.a11;
        denseMatrix64F.data[1] = fixedMatrix2x2_64F.a12;
        denseMatrix64F.data[2] = fixedMatrix2x2_64F.a21;
        denseMatrix64F.data[3] = fixedMatrix2x2_64F.a22;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix3x3_64F fixedMatrix3x3_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(3, 3);
        }
        if (fixedMatrix3x3_64F.getNumRows() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (fixedMatrix3x3_64F.getNumCols() != denseMatrix64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        denseMatrix64F.data[0] = fixedMatrix3x3_64F.a11;
        denseMatrix64F.data[1] = fixedMatrix3x3_64F.a12;
        denseMatrix64F.data[2] = fixedMatrix3x3_64F.a13;
        denseMatrix64F.data[3] = fixedMatrix3x3_64F.a21;
        denseMatrix64F.data[4] = fixedMatrix3x3_64F.a22;
        denseMatrix64F.data[5] = fixedMatrix3x3_64F.a23;
        denseMatrix64F.data[6] = fixedMatrix3x3_64F.a31;
        denseMatrix64F.data[7] = fixedMatrix3x3_64F.a32;
        denseMatrix64F.data[8] = fixedMatrix3x3_64F.a33;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix4x4_64F fixedMatrix4x4_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(4, 4);
        }
        if (fixedMatrix4x4_64F.getNumRows() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (fixedMatrix4x4_64F.getNumCols() != denseMatrix64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        denseMatrix64F.data[0] = fixedMatrix4x4_64F.a11;
        denseMatrix64F.data[1] = fixedMatrix4x4_64F.a12;
        denseMatrix64F.data[2] = fixedMatrix4x4_64F.a13;
        denseMatrix64F.data[3] = fixedMatrix4x4_64F.a14;
        denseMatrix64F.data[4] = fixedMatrix4x4_64F.a21;
        denseMatrix64F.data[5] = fixedMatrix4x4_64F.a22;
        denseMatrix64F.data[6] = fixedMatrix4x4_64F.a23;
        denseMatrix64F.data[7] = fixedMatrix4x4_64F.a24;
        denseMatrix64F.data[8] = fixedMatrix4x4_64F.a31;
        denseMatrix64F.data[9] = fixedMatrix4x4_64F.a32;
        denseMatrix64F.data[10] = fixedMatrix4x4_64F.a33;
        denseMatrix64F.data[11] = fixedMatrix4x4_64F.a34;
        denseMatrix64F.data[12] = fixedMatrix4x4_64F.a41;
        denseMatrix64F.data[13] = fixedMatrix4x4_64F.a42;
        denseMatrix64F.data[14] = fixedMatrix4x4_64F.a43;
        denseMatrix64F.data[15] = fixedMatrix4x4_64F.a44;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix5x5_64F fixedMatrix5x5_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(5, 5);
        }
        if (fixedMatrix5x5_64F.getNumRows() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (fixedMatrix5x5_64F.getNumCols() != denseMatrix64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        denseMatrix64F.data[0] = fixedMatrix5x5_64F.a11;
        denseMatrix64F.data[1] = fixedMatrix5x5_64F.a12;
        denseMatrix64F.data[2] = fixedMatrix5x5_64F.a13;
        denseMatrix64F.data[3] = fixedMatrix5x5_64F.a14;
        denseMatrix64F.data[4] = fixedMatrix5x5_64F.a15;
        denseMatrix64F.data[5] = fixedMatrix5x5_64F.a21;
        denseMatrix64F.data[6] = fixedMatrix5x5_64F.a22;
        denseMatrix64F.data[7] = fixedMatrix5x5_64F.a23;
        denseMatrix64F.data[8] = fixedMatrix5x5_64F.a24;
        denseMatrix64F.data[9] = fixedMatrix5x5_64F.a25;
        denseMatrix64F.data[10] = fixedMatrix5x5_64F.a31;
        denseMatrix64F.data[11] = fixedMatrix5x5_64F.a32;
        denseMatrix64F.data[12] = fixedMatrix5x5_64F.a33;
        denseMatrix64F.data[13] = fixedMatrix5x5_64F.a34;
        denseMatrix64F.data[14] = fixedMatrix5x5_64F.a35;
        denseMatrix64F.data[15] = fixedMatrix5x5_64F.a41;
        denseMatrix64F.data[16] = fixedMatrix5x5_64F.a42;
        denseMatrix64F.data[17] = fixedMatrix5x5_64F.a43;
        denseMatrix64F.data[18] = fixedMatrix5x5_64F.a44;
        denseMatrix64F.data[19] = fixedMatrix5x5_64F.a45;
        denseMatrix64F.data[20] = fixedMatrix5x5_64F.a51;
        denseMatrix64F.data[21] = fixedMatrix5x5_64F.a52;
        denseMatrix64F.data[22] = fixedMatrix5x5_64F.a53;
        denseMatrix64F.data[23] = fixedMatrix5x5_64F.a54;
        denseMatrix64F.data[24] = fixedMatrix5x5_64F.a55;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix6x6_64F fixedMatrix6x6_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(6, 6);
        }
        if (fixedMatrix6x6_64F.getNumRows() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (fixedMatrix6x6_64F.getNumCols() != denseMatrix64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        denseMatrix64F.data[0] = fixedMatrix6x6_64F.a11;
        denseMatrix64F.data[1] = fixedMatrix6x6_64F.a12;
        denseMatrix64F.data[2] = fixedMatrix6x6_64F.a13;
        denseMatrix64F.data[3] = fixedMatrix6x6_64F.a14;
        denseMatrix64F.data[4] = fixedMatrix6x6_64F.a15;
        denseMatrix64F.data[5] = fixedMatrix6x6_64F.a16;
        denseMatrix64F.data[6] = fixedMatrix6x6_64F.a21;
        denseMatrix64F.data[7] = fixedMatrix6x6_64F.a22;
        denseMatrix64F.data[8] = fixedMatrix6x6_64F.a23;
        denseMatrix64F.data[9] = fixedMatrix6x6_64F.a24;
        denseMatrix64F.data[10] = fixedMatrix6x6_64F.a25;
        denseMatrix64F.data[11] = fixedMatrix6x6_64F.a26;
        denseMatrix64F.data[12] = fixedMatrix6x6_64F.a31;
        denseMatrix64F.data[13] = fixedMatrix6x6_64F.a32;
        denseMatrix64F.data[14] = fixedMatrix6x6_64F.a33;
        denseMatrix64F.data[15] = fixedMatrix6x6_64F.a34;
        denseMatrix64F.data[16] = fixedMatrix6x6_64F.a35;
        denseMatrix64F.data[17] = fixedMatrix6x6_64F.a36;
        denseMatrix64F.data[18] = fixedMatrix6x6_64F.a41;
        denseMatrix64F.data[19] = fixedMatrix6x6_64F.a42;
        denseMatrix64F.data[20] = fixedMatrix6x6_64F.a43;
        denseMatrix64F.data[21] = fixedMatrix6x6_64F.a44;
        denseMatrix64F.data[22] = fixedMatrix6x6_64F.a45;
        denseMatrix64F.data[23] = fixedMatrix6x6_64F.a46;
        denseMatrix64F.data[24] = fixedMatrix6x6_64F.a51;
        denseMatrix64F.data[25] = fixedMatrix6x6_64F.a52;
        denseMatrix64F.data[26] = fixedMatrix6x6_64F.a53;
        denseMatrix64F.data[27] = fixedMatrix6x6_64F.a54;
        denseMatrix64F.data[28] = fixedMatrix6x6_64F.a55;
        denseMatrix64F.data[29] = fixedMatrix6x6_64F.a56;
        denseMatrix64F.data[30] = fixedMatrix6x6_64F.a61;
        denseMatrix64F.data[31] = fixedMatrix6x6_64F.a62;
        denseMatrix64F.data[32] = fixedMatrix6x6_64F.a63;
        denseMatrix64F.data[33] = fixedMatrix6x6_64F.a64;
        denseMatrix64F.data[34] = fixedMatrix6x6_64F.a65;
        denseMatrix64F.data[35] = fixedMatrix6x6_64F.a66;
        return denseMatrix64F;
    }

    public static FixedMatrix2x2_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        if (fixedMatrix2x2_64F == null) {
            fixedMatrix2x2_64F = new FixedMatrix2x2_64F();
        }
        if (denseMatrix64F.getNumRows() != fixedMatrix2x2_64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (denseMatrix64F.getNumCols() != fixedMatrix2x2_64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        fixedMatrix2x2_64F.a11 = denseMatrix64F.data[0];
        fixedMatrix2x2_64F.a12 = denseMatrix64F.data[1];
        fixedMatrix2x2_64F.a21 = denseMatrix64F.data[2];
        fixedMatrix2x2_64F.a22 = denseMatrix64F.data[3];
        return fixedMatrix2x2_64F;
    }

    public static FixedMatrix3x3_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        if (fixedMatrix3x3_64F == null) {
            fixedMatrix3x3_64F = new FixedMatrix3x3_64F();
        }
        if (denseMatrix64F.getNumRows() != fixedMatrix3x3_64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (denseMatrix64F.getNumCols() != fixedMatrix3x3_64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        fixedMatrix3x3_64F.a11 = denseMatrix64F.data[0];
        fixedMatrix3x3_64F.a12 = denseMatrix64F.data[1];
        fixedMatrix3x3_64F.a13 = denseMatrix64F.data[2];
        fixedMatrix3x3_64F.a21 = denseMatrix64F.data[3];
        fixedMatrix3x3_64F.a22 = denseMatrix64F.data[4];
        fixedMatrix3x3_64F.a23 = denseMatrix64F.data[5];
        fixedMatrix3x3_64F.a31 = denseMatrix64F.data[6];
        fixedMatrix3x3_64F.a32 = denseMatrix64F.data[7];
        fixedMatrix3x3_64F.a33 = denseMatrix64F.data[8];
        return fixedMatrix3x3_64F;
    }

    public static FixedMatrix4x4_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix4x4_64F fixedMatrix4x4_64F) {
        if (fixedMatrix4x4_64F == null) {
            fixedMatrix4x4_64F = new FixedMatrix4x4_64F();
        }
        if (denseMatrix64F.getNumRows() != fixedMatrix4x4_64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (denseMatrix64F.getNumCols() != fixedMatrix4x4_64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        fixedMatrix4x4_64F.a11 = denseMatrix64F.data[0];
        fixedMatrix4x4_64F.a12 = denseMatrix64F.data[1];
        fixedMatrix4x4_64F.a13 = denseMatrix64F.data[2];
        fixedMatrix4x4_64F.a14 = denseMatrix64F.data[3];
        fixedMatrix4x4_64F.a21 = denseMatrix64F.data[4];
        fixedMatrix4x4_64F.a22 = denseMatrix64F.data[5];
        fixedMatrix4x4_64F.a23 = denseMatrix64F.data[6];
        fixedMatrix4x4_64F.a24 = denseMatrix64F.data[7];
        fixedMatrix4x4_64F.a31 = denseMatrix64F.data[8];
        fixedMatrix4x4_64F.a32 = denseMatrix64F.data[9];
        fixedMatrix4x4_64F.a33 = denseMatrix64F.data[10];
        fixedMatrix4x4_64F.a34 = denseMatrix64F.data[11];
        fixedMatrix4x4_64F.a41 = denseMatrix64F.data[12];
        fixedMatrix4x4_64F.a42 = denseMatrix64F.data[13];
        fixedMatrix4x4_64F.a43 = denseMatrix64F.data[14];
        fixedMatrix4x4_64F.a44 = denseMatrix64F.data[15];
        return fixedMatrix4x4_64F;
    }

    public static FixedMatrix5x5_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix5x5_64F fixedMatrix5x5_64F) {
        if (fixedMatrix5x5_64F == null) {
            fixedMatrix5x5_64F = new FixedMatrix5x5_64F();
        }
        if (denseMatrix64F.getNumRows() != fixedMatrix5x5_64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (denseMatrix64F.getNumCols() != fixedMatrix5x5_64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        fixedMatrix5x5_64F.a11 = denseMatrix64F.data[0];
        fixedMatrix5x5_64F.a12 = denseMatrix64F.data[1];
        fixedMatrix5x5_64F.a13 = denseMatrix64F.data[2];
        fixedMatrix5x5_64F.a14 = denseMatrix64F.data[3];
        fixedMatrix5x5_64F.a15 = denseMatrix64F.data[4];
        fixedMatrix5x5_64F.a21 = denseMatrix64F.data[5];
        fixedMatrix5x5_64F.a22 = denseMatrix64F.data[6];
        fixedMatrix5x5_64F.a23 = denseMatrix64F.data[7];
        fixedMatrix5x5_64F.a24 = denseMatrix64F.data[8];
        fixedMatrix5x5_64F.a25 = denseMatrix64F.data[9];
        fixedMatrix5x5_64F.a31 = denseMatrix64F.data[10];
        fixedMatrix5x5_64F.a32 = denseMatrix64F.data[11];
        fixedMatrix5x5_64F.a33 = denseMatrix64F.data[12];
        fixedMatrix5x5_64F.a34 = denseMatrix64F.data[13];
        fixedMatrix5x5_64F.a35 = denseMatrix64F.data[14];
        fixedMatrix5x5_64F.a41 = denseMatrix64F.data[15];
        fixedMatrix5x5_64F.a42 = denseMatrix64F.data[16];
        fixedMatrix5x5_64F.a43 = denseMatrix64F.data[17];
        fixedMatrix5x5_64F.a44 = denseMatrix64F.data[18];
        fixedMatrix5x5_64F.a45 = denseMatrix64F.data[19];
        fixedMatrix5x5_64F.a51 = denseMatrix64F.data[20];
        fixedMatrix5x5_64F.a52 = denseMatrix64F.data[21];
        fixedMatrix5x5_64F.a53 = denseMatrix64F.data[22];
        fixedMatrix5x5_64F.a54 = denseMatrix64F.data[23];
        fixedMatrix5x5_64F.a55 = denseMatrix64F.data[24];
        return fixedMatrix5x5_64F;
    }

    public static FixedMatrix6x6_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix6x6_64F fixedMatrix6x6_64F) {
        if (fixedMatrix6x6_64F == null) {
            fixedMatrix6x6_64F = new FixedMatrix6x6_64F();
        }
        if (denseMatrix64F.getNumRows() != fixedMatrix6x6_64F.getNumRows()) {
            throw new IllegalArgumentException("Number of rows do not match");
        }
        if (denseMatrix64F.getNumCols() != fixedMatrix6x6_64F.getNumCols()) {
            throw new IllegalArgumentException("Number of columns do not match");
        }
        fixedMatrix6x6_64F.a11 = denseMatrix64F.data[0];
        fixedMatrix6x6_64F.a12 = denseMatrix64F.data[1];
        fixedMatrix6x6_64F.a13 = denseMatrix64F.data[2];
        fixedMatrix6x6_64F.a14 = denseMatrix64F.data[3];
        fixedMatrix6x6_64F.a15 = denseMatrix64F.data[4];
        fixedMatrix6x6_64F.a16 = denseMatrix64F.data[5];
        fixedMatrix6x6_64F.a21 = denseMatrix64F.data[6];
        fixedMatrix6x6_64F.a22 = denseMatrix64F.data[7];
        fixedMatrix6x6_64F.a23 = denseMatrix64F.data[8];
        fixedMatrix6x6_64F.a24 = denseMatrix64F.data[9];
        fixedMatrix6x6_64F.a25 = denseMatrix64F.data[10];
        fixedMatrix6x6_64F.a26 = denseMatrix64F.data[11];
        fixedMatrix6x6_64F.a31 = denseMatrix64F.data[12];
        fixedMatrix6x6_64F.a32 = denseMatrix64F.data[13];
        fixedMatrix6x6_64F.a33 = denseMatrix64F.data[14];
        fixedMatrix6x6_64F.a34 = denseMatrix64F.data[15];
        fixedMatrix6x6_64F.a35 = denseMatrix64F.data[16];
        fixedMatrix6x6_64F.a36 = denseMatrix64F.data[17];
        fixedMatrix6x6_64F.a41 = denseMatrix64F.data[18];
        fixedMatrix6x6_64F.a42 = denseMatrix64F.data[19];
        fixedMatrix6x6_64F.a43 = denseMatrix64F.data[20];
        fixedMatrix6x6_64F.a44 = denseMatrix64F.data[21];
        fixedMatrix6x6_64F.a45 = denseMatrix64F.data[22];
        fixedMatrix6x6_64F.a46 = denseMatrix64F.data[23];
        fixedMatrix6x6_64F.a51 = denseMatrix64F.data[24];
        fixedMatrix6x6_64F.a52 = denseMatrix64F.data[25];
        fixedMatrix6x6_64F.a53 = denseMatrix64F.data[26];
        fixedMatrix6x6_64F.a54 = denseMatrix64F.data[27];
        fixedMatrix6x6_64F.a55 = denseMatrix64F.data[28];
        fixedMatrix6x6_64F.a56 = denseMatrix64F.data[29];
        fixedMatrix6x6_64F.a61 = denseMatrix64F.data[30];
        fixedMatrix6x6_64F.a62 = denseMatrix64F.data[31];
        fixedMatrix6x6_64F.a63 = denseMatrix64F.data[32];
        fixedMatrix6x6_64F.a64 = denseMatrix64F.data[33];
        fixedMatrix6x6_64F.a65 = denseMatrix64F.data[34];
        fixedMatrix6x6_64F.a66 = denseMatrix64F.data[35];
        return fixedMatrix6x6_64F;
    }

    public static DenseMatrix64F convert(FixedMatrix2_64F fixedMatrix2_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(2, 1);
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 2) {
            throw new IllegalArgumentException("Length of input vector is not 2.  It is " + n);
        }
        denseMatrix64F.data[0] = fixedMatrix2_64F.a1;
        denseMatrix64F.data[1] = fixedMatrix2_64F.a2;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix3_64F fixedMatrix3_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(3, 1);
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 3) {
            throw new IllegalArgumentException("Length of input vector is not 3.  It is " + n);
        }
        denseMatrix64F.data[0] = fixedMatrix3_64F.a1;
        denseMatrix64F.data[1] = fixedMatrix3_64F.a2;
        denseMatrix64F.data[2] = fixedMatrix3_64F.a3;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix4_64F fixedMatrix4_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(4, 1);
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 4) {
            throw new IllegalArgumentException("Length of input vector is not 4.  It is " + n);
        }
        denseMatrix64F.data[0] = fixedMatrix4_64F.a1;
        denseMatrix64F.data[1] = fixedMatrix4_64F.a2;
        denseMatrix64F.data[2] = fixedMatrix4_64F.a3;
        denseMatrix64F.data[3] = fixedMatrix4_64F.a4;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix5_64F fixedMatrix5_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(5, 1);
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 5) {
            throw new IllegalArgumentException("Length of input vector is not 5.  It is " + n);
        }
        denseMatrix64F.data[0] = fixedMatrix5_64F.a1;
        denseMatrix64F.data[1] = fixedMatrix5_64F.a2;
        denseMatrix64F.data[2] = fixedMatrix5_64F.a3;
        denseMatrix64F.data[3] = fixedMatrix5_64F.a4;
        denseMatrix64F.data[4] = fixedMatrix5_64F.a5;
        return denseMatrix64F;
    }

    public static DenseMatrix64F convert(FixedMatrix6_64F fixedMatrix6_64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(6, 1);
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 6) {
            throw new IllegalArgumentException("Length of input vector is not 6.  It is " + n);
        }
        denseMatrix64F.data[0] = fixedMatrix6_64F.a1;
        denseMatrix64F.data[1] = fixedMatrix6_64F.a2;
        denseMatrix64F.data[2] = fixedMatrix6_64F.a3;
        denseMatrix64F.data[3] = fixedMatrix6_64F.a4;
        denseMatrix64F.data[4] = fixedMatrix6_64F.a5;
        denseMatrix64F.data[5] = fixedMatrix6_64F.a6;
        return denseMatrix64F;
    }

    public static FixedMatrix2_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix2_64F fixedMatrix2_64F) {
        if (fixedMatrix2_64F == null) {
            fixedMatrix2_64F = new FixedMatrix2_64F();
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 2) {
            throw new IllegalArgumentException("Length of input vector is not 2.  It is " + n);
        }
        fixedMatrix2_64F.a1 = denseMatrix64F.data[0];
        fixedMatrix2_64F.a2 = denseMatrix64F.data[1];
        return fixedMatrix2_64F;
    }

    public static FixedMatrix3_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix3_64F fixedMatrix3_64F) {
        if (fixedMatrix3_64F == null) {
            fixedMatrix3_64F = new FixedMatrix3_64F();
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 3) {
            throw new IllegalArgumentException("Length of input vector is not 3.  It is " + n);
        }
        fixedMatrix3_64F.a1 = denseMatrix64F.data[0];
        fixedMatrix3_64F.a2 = denseMatrix64F.data[1];
        fixedMatrix3_64F.a3 = denseMatrix64F.data[2];
        return fixedMatrix3_64F;
    }

    public static FixedMatrix4_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix4_64F fixedMatrix4_64F) {
        if (fixedMatrix4_64F == null) {
            fixedMatrix4_64F = new FixedMatrix4_64F();
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 4) {
            throw new IllegalArgumentException("Length of input vector is not 4.  It is " + n);
        }
        fixedMatrix4_64F.a1 = denseMatrix64F.data[0];
        fixedMatrix4_64F.a2 = denseMatrix64F.data[1];
        fixedMatrix4_64F.a3 = denseMatrix64F.data[2];
        fixedMatrix4_64F.a4 = denseMatrix64F.data[3];
        return fixedMatrix4_64F;
    }

    public static FixedMatrix5_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix5_64F fixedMatrix5_64F) {
        if (fixedMatrix5_64F == null) {
            fixedMatrix5_64F = new FixedMatrix5_64F();
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 5) {
            throw new IllegalArgumentException("Length of input vector is not 5.  It is " + n);
        }
        fixedMatrix5_64F.a1 = denseMatrix64F.data[0];
        fixedMatrix5_64F.a2 = denseMatrix64F.data[1];
        fixedMatrix5_64F.a3 = denseMatrix64F.data[2];
        fixedMatrix5_64F.a4 = denseMatrix64F.data[3];
        fixedMatrix5_64F.a5 = denseMatrix64F.data[4];
        return fixedMatrix5_64F;
    }

    public static FixedMatrix6_64F convert(DenseMatrix64F denseMatrix64F, FixedMatrix6_64F fixedMatrix6_64F) {
        if (fixedMatrix6_64F == null) {
            fixedMatrix6_64F = new FixedMatrix6_64F();
        }
        if (denseMatrix64F.getNumRows() != 1 && denseMatrix64F.getNumCols() != 1) {
            throw new IllegalArgumentException("One row or column must have a length of 1 for it to be a vector");
        }
        int n = Math.max(denseMatrix64F.getNumRows(), denseMatrix64F.getNumCols());
        if (n != 6) {
            throw new IllegalArgumentException("Length of input vector is not 6.  It is " + n);
        }
        fixedMatrix6_64F.a1 = denseMatrix64F.data[0];
        fixedMatrix6_64F.a2 = denseMatrix64F.data[1];
        fixedMatrix6_64F.a3 = denseMatrix64F.data[2];
        fixedMatrix6_64F.a4 = denseMatrix64F.data[3];
        fixedMatrix6_64F.a5 = denseMatrix64F.data[4];
        fixedMatrix6_64F.a6 = denseMatrix64F.data[5];
        return fixedMatrix6_64F;
    }

    public static void convert(DenseMatrix64F denseMatrix64F, BlockMatrix64F blockMatrix64F) {
        if (denseMatrix64F.numRows != blockMatrix64F.numRows || denseMatrix64F.numCols != blockMatrix64F.numCols) {
            throw new IllegalArgumentException("Must be the same size.");
        }
        for (int i = 0; i < blockMatrix64F.numRows; i += blockMatrix64F.blockLength) {
            int n = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numRows - i);
            for (int j = 0; j < blockMatrix64F.numCols; j += blockMatrix64F.blockLength) {
                int n2 = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numCols - j);
                int n3 = i * blockMatrix64F.numCols + n * j;
                int n4 = i * blockMatrix64F.numCols + j;
                for (int k = 0; k < n; ++k) {
                    System.arraycopy(denseMatrix64F.data, n4, blockMatrix64F.data, n3, n2);
                    n3 += n2;
                    n4 += blockMatrix64F.numCols;
                }
            }
        }
    }

    public static DenseMatrix64F convert(BlockMatrix64F blockMatrix64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F != null) {
            if (denseMatrix64F.numRows != blockMatrix64F.numRows || denseMatrix64F.numCols != blockMatrix64F.numCols) {
                throw new IllegalArgumentException("Must be the same size.");
            }
        } else {
            denseMatrix64F = new DenseMatrix64F(blockMatrix64F.numRows, blockMatrix64F.numCols);
        }
        for (int i = 0; i < blockMatrix64F.numRows; i += blockMatrix64F.blockLength) {
            int n = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numRows - i);
            for (int j = 0; j < blockMatrix64F.numCols; j += blockMatrix64F.blockLength) {
                int n2 = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numCols - j);
                int n3 = i * blockMatrix64F.numCols + n * j;
                int n4 = i * denseMatrix64F.numCols + j;
                for (int k = 0; k < n; ++k) {
                    System.arraycopy(blockMatrix64F.data, n3, denseMatrix64F.data, n4, n2);
                    n3 += n2;
                    n4 += denseMatrix64F.numCols;
                }
            }
        }
        return denseMatrix64F;
    }
}

