/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CCommonOps;

public class CRandomMatrices {
    public static CDenseMatrix64F createRandom(int n, int n2, Random random) {
        return CRandomMatrices.createRandom(n, n2, -1.0, 1.0, random);
    }

    public static CDenseMatrix64F createRandom(int n, int n2, double d, double d2, Random random) {
        CDenseMatrix64F cDenseMatrix64F = new CDenseMatrix64F(n, n2);
        CRandomMatrices.setRandom(cDenseMatrix64F, d, d2, random);
        return cDenseMatrix64F;
    }

    public static void setRandom(CDenseMatrix64F cDenseMatrix64F, Random random) {
        CRandomMatrices.setRandom(cDenseMatrix64F, 0.0, 1.0, random);
    }

    public static void setRandom(CD1Matrix64F cD1Matrix64F, double d, double d2, Random random) {
        double[] dArray = cD1Matrix64F.getData();
        int n = cD1Matrix64F.getDataLength();
        double d3 = d2 - d;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d3 * random.nextDouble() + d;
        }
    }

    public static CDenseMatrix64F createHermPosDef(int n, Random random) {
        CDenseMatrix64F cDenseMatrix64F = CRandomMatrices.createRandom(n, 1, random);
        CDenseMatrix64F cDenseMatrix64F2 = new CDenseMatrix64F(1, n);
        CDenseMatrix64F cDenseMatrix64F3 = new CDenseMatrix64F(n, n);
        CCommonOps.transposeConjugate(cDenseMatrix64F, cDenseMatrix64F2);
        CCommonOps.mult(cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        for (int i = 0; i < n; ++i) {
            int n2 = 2 * (i * n + i);
            cDenseMatrix64F3.data[n2] = cDenseMatrix64F3.data[n2] + 1.0;
        }
        return cDenseMatrix64F3;
    }

    public static CDenseMatrix64F createHermitian(int n, double d, double d2, Random random) {
        CDenseMatrix64F cDenseMatrix64F = new CDenseMatrix64F(n, n);
        CRandomMatrices.setHermitian(cDenseMatrix64F, d, d2, random);
        return cDenseMatrix64F;
    }

    public static void setHermitian(CDenseMatrix64F cDenseMatrix64F, double d, double d2, Random random) {
        if (cDenseMatrix64F.numRows != cDenseMatrix64F.numCols) {
            throw new IllegalArgumentException("A must be a square matrix");
        }
        double d3 = d2 - d;
        int n = cDenseMatrix64F.numRows;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d4 = random.nextDouble() * d3 + d;
                double d5 = random.nextDouble() * d3 + d;
                cDenseMatrix64F.set(i, j, d4, d5);
                cDenseMatrix64F.set(j, i, d4, -d5);
            }
        }
    }
}

