/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.factory;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock_D64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL_D64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecomposition_B64_to_D64;
import org.ejml.alg.dense.decomposition.eig.SwitchingEigenDecomposition;
import org.ejml.alg.dense.decomposition.eig.SymmetricQRAlgorithmDecomposition_D64;
import org.ejml.alg.dense.decomposition.eig.WatchedDoubleStepQRDecomposition_D64;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionHouseholder_D64;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecomposition_B64_to_D64;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt_D64;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrDecompose_D64;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.decomposition.CholeskyLDLDecomposition;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.interfaces.decomposition.TridiagonalSimilarDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.EigenOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class DecompositionFactory {
    public static CholeskyDecomposition<DenseMatrix64F> chol(int n, boolean bl) {
        if (n < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            return new CholeskyDecompositionInner_D64(bl);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new CholeskyDecomposition_B64_to_D64(bl);
        }
        return new CholeskyDecompositionBlock_D64(EjmlParameters.BLOCK_WIDTH_CHOL);
    }

    public static CholeskyLDLDecomposition<DenseMatrix64F> cholLDL(int n) {
        return new CholeskyDecompositionLDL_D64();
    }

    public static LUDecomposition<DenseMatrix64F> lu(int n, int n2) {
        return new LUDecompositionAlt_D64();
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return new SvdImplicitQrDecompose_D64(bl3, bl, bl2, false);
    }

    public static QRDecomposition<DenseMatrix64F> qr(int n, int n2) {
        return new QRDecompositionHouseholderColumn_D64();
    }

    public static QRPDecomposition<DenseMatrix64F> qrp(int n, int n2) {
        return new QRColPivDecompositionHouseholderColumn_D64();
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int n, boolean bl) {
        return new SwitchingEigenDecomposition(n, bl, 1.0E-8);
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int n, boolean bl, boolean bl2) {
        if (bl2) {
            TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonalSimilarDecomposition = DecompositionFactory.tridiagonal(n);
            return new SymmetricQRAlgorithmDecomposition_D64(tridiagonalSimilarDecomposition, bl);
        }
        return new WatchedDoubleStepQRDecomposition_D64(bl);
    }

    public static double quality(DenseMatrix64F denseMatrix64F, SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition) {
        return DecompositionFactory.quality(denseMatrix64F, singularValueDecomposition.getU(null, false), singularValueDecomposition.getW(null), singularValueDecomposition.getV(null, true));
    }

    public static double quality(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4) {
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(denseMatrix64F2.numRows, denseMatrix64F3.numCols);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F3, denseMatrix64F5);
        DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(denseMatrix64F5.numRows, denseMatrix64F4.numCols);
        CommonOps.mult(denseMatrix64F5, denseMatrix64F4, denseMatrix64F6);
        double d = NormOps.normF(denseMatrix64F6);
        return SpecializedOps.diffNormF(denseMatrix64F, denseMatrix64F6) / d;
    }

    public static double quality(DenseMatrix64F denseMatrix64F, EigenDecomposition<DenseMatrix64F> eigenDecomposition) {
        DenseMatrix64F denseMatrix64F2 = denseMatrix64F;
        DenseMatrix64F denseMatrix64F3 = EigenOps.createMatrixV(eigenDecomposition);
        DenseMatrix64F denseMatrix64F4 = EigenOps.createMatrixD(eigenDecomposition);
        DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(denseMatrix64F2.numRows, denseMatrix64F3.numCols);
        CommonOps.mult(denseMatrix64F2, denseMatrix64F3, denseMatrix64F5);
        DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(denseMatrix64F3.numRows, denseMatrix64F4.numCols);
        CommonOps.mult(denseMatrix64F3, denseMatrix64F4, denseMatrix64F6);
        DenseMatrix64F denseMatrix64F7 = new DenseMatrix64F(denseMatrix64F5.numRows, denseMatrix64F5.numCols);
        CommonOps.subtract((D1Matrix64F)denseMatrix64F5, (D1Matrix64F)denseMatrix64F6, (D1Matrix64F)denseMatrix64F7);
        double d = NormOps.normF(denseMatrix64F7);
        double d2 = NormOps.normF(denseMatrix64F5);
        double d3 = d / d2;
        return d3;
    }

    public static TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonal(int n) {
        if (n >= 1800) {
            return new TridiagonalDecomposition_B64_to_D64();
        }
        return new TridiagonalDecompositionHouseholder_D64();
    }

    public static <T extends RealMatrix64F> boolean decomposeSafe(DecompositionInterface<T> decompositionInterface, T t) {
        if (decompositionInterface.inputModified()) {
            return decompositionInterface.decompose(t.copy());
        }
        return decompositionInterface.decompose(t);
    }
}

