/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import org.ejml.equation.Function;
import org.ejml.equation.Symbol;
import org.ejml.equation.Variable;
import org.ejml.equation.VariableSpecial;

class TokenList {
    Token first;
    Token last;
    int size = 0;

    public TokenList() {
    }

    public TokenList(Token token, Token token2) {
        this.first = token;
        this.last = token2;
        Token token3 = token;
        while (token3 != null) {
            ++this.size;
            token3 = token3.next;
        }
    }

    public Token add(Function function) {
        Token token = new Token(function);
        this.push(token);
        return token;
    }

    public Token add(Variable variable) {
        Token token = new Token(variable);
        this.push(token);
        return token;
    }

    public Token add(Symbol symbol) {
        Token token = new Token(symbol);
        this.push(token);
        return token;
    }

    public Token add(String string) {
        Token token = new Token(string);
        this.push(token);
        return token;
    }

    public void push(Token token) {
        ++this.size;
        if (this.first == null) {
            this.first = token;
            this.last = token;
            token.previous = null;
            token.next = null;
        } else {
            this.last.next = token;
            token.previous = this.last;
            token.next = null;
            this.last = token;
        }
    }

    public void insert(Token token, Token token2) {
        if (token == null) {
            if (this.size == 0) {
                this.push(token2);
            } else {
                this.first.previous = token2;
                token2.previous = null;
                token2.next = this.first;
                this.first = token2;
                ++this.size;
            }
        } else if (token == this.last || null == this.last) {
            this.push(token2);
        } else {
            token2.next = token.next;
            token2.previous = token;
            token.next.previous = token2;
            token.next = token2;
            ++this.size;
        }
    }

    public void remove(Token token) {
        if (token == this.first) {
            this.first = this.first.next;
        }
        if (token == this.last) {
            this.last = this.last.previous;
        }
        if (token.next != null) {
            token.next.previous = token.previous;
        }
        if (token.previous != null) {
            token.previous.next = token.next;
        }
        token.previous = null;
        token.next = null;
        --this.size;
    }

    public void replace(Token token, Token token2) {
        if (this.first == token) {
            this.first = token2;
        }
        if (this.last == token) {
            this.last = token2;
        }
        token2.next = token.next;
        token2.previous = token.previous;
        if (token.next != null) {
            token.next.previous = token2;
        }
        if (token.previous != null) {
            token.previous.next = token2;
        }
        token.previous = null;
        token.next = null;
    }

    public TokenList extractSubList(Token token, Token token2) {
        if (token == token2) {
            this.remove(token);
            return new TokenList(token, token);
        }
        if (this.first == token) {
            this.first = token2.next;
        }
        if (this.last == token2) {
            this.last = token.previous;
        }
        if (token.previous != null) {
            token.previous.next = token2.next;
        }
        if (token2.next != null) {
            token2.next.previous = token.previous;
        }
        token.previous = null;
        token2.next = null;
        TokenList tokenList = new TokenList(token, token2);
        this.size -= tokenList.size();
        return tokenList;
    }

    public String toString() {
        String string = "";
        Token token = this.first;
        while (token != null) {
            string = string + token + " ";
            token = token.next;
        }
        return string;
    }

    public Token getFirst() {
        return this.first;
    }

    public Token getLast() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    public void print() {
        Token token = this.first;
        while (token != null) {
            System.out.println(token);
            token = token.next;
        }
    }

    public static enum Type {
        FUNCTION,
        VARIABLE,
        SYMBOL,
        WORD;

    }

    public static class Token {
        public Token next;
        public Token previous;
        public Function function;
        public Variable variable;
        public Symbol symbol;
        public String word;

        public Token(Function function) {
            this.function = function;
        }

        public Token(Variable variable) {
            this.variable = variable;
        }

        public Token(VariableSpecial.Special special) {
            this.variable = new VariableSpecial(special);
        }

        public Token(Symbol symbol) {
            this.symbol = symbol;
        }

        public Token(String string) {
            this.word = string;
        }

        public Type getType() {
            if (this.function != null) {
                return Type.FUNCTION;
            }
            if (this.variable != null) {
                return Type.VARIABLE;
            }
            if (this.word != null) {
                return Type.WORD;
            }
            return Type.SYMBOL;
        }

        public Variable getVariable() {
            return this.variable;
        }

        public Function getFunction() {
            return this.function;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public String getWord() {
            return this.word;
        }

        public String toString() {
            switch (this.getType()) {
                case FUNCTION: {
                    return "Func:" + this.function.getName();
                }
                case SYMBOL: {
                    return "" + (Object)((Object)this.symbol);
                }
                case VARIABLE: {
                    return this.variable.toString();
                }
                case WORD: {
                    return "Word:" + this.word;
                }
            }
            throw new RuntimeException("Unknown type");
        }
    }
}

