/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.Operation;
import org.ejml.equation.Symbol;
import org.ejml.equation.Variable;

public class ManagerFunctions {
    Map<String, Input1> input1 = new HashMap<String, Input1>();
    Map<String, InputN> inputN = new HashMap<String, InputN>();
    protected ManagerTempVariables managerTemp;

    public ManagerFunctions() {
        this.addBuiltIn();
    }

    public boolean isFunctionName(String string) {
        if (this.input1.containsKey(string)) {
            return true;
        }
        return this.inputN.containsKey(string);
    }

    public Operation.Info create(String string, Variable variable) {
        Input1 input1 = this.input1.get(string);
        if (input1 == null) {
            return null;
        }
        return input1.create(variable, this.managerTemp);
    }

    public Operation.Info create(String string, List<Variable> list) {
        InputN inputN = this.inputN.get(string);
        if (inputN == null) {
            return null;
        }
        return inputN.create(list, this.managerTemp);
    }

    public Operation.Info create(char c, Variable variable) {
        switch (c) {
            case '\'': {
                return Operation.transpose(variable, this.managerTemp);
            }
        }
        throw new RuntimeException("Unknown operation " + c);
    }

    public Operation.Info create(Symbol symbol, Variable variable, Variable variable2) {
        switch (symbol) {
            case PLUS: {
                return Operation.add(variable, variable2, this.managerTemp);
            }
            case MINUS: {
                return Operation.subtract(variable, variable2, this.managerTemp);
            }
            case TIMES: {
                return Operation.multiply(variable, variable2, this.managerTemp);
            }
            case RDIVIDE: {
                return Operation.divide(variable, variable2, this.managerTemp);
            }
            case LDIVIDE: {
                return Operation.divide(variable2, variable, this.managerTemp);
            }
            case POWER: {
                return Operation.pow(variable, variable2, this.managerTemp);
            }
            case ELEMENT_DIVIDE: {
                return Operation.elementDivision(variable, variable2, this.managerTemp);
            }
            case ELEMENT_TIMES: {
                return Operation.elementMult(variable, variable2, this.managerTemp);
            }
            case ELEMENT_POWER: {
                return Operation.elementPow(variable, variable2, this.managerTemp);
            }
        }
        throw new RuntimeException("Unknown operation " + (Object)((Object)symbol));
    }

    public void setManagerTemp(ManagerTempVariables managerTempVariables) {
        this.managerTemp = managerTempVariables;
    }

    public void add(String string, Input1 input1) {
        this.input1.put(string, input1);
    }

    public void add(String string, InputN inputN) {
        this.inputN.put(string, inputN);
    }

    private void addBuiltIn() {
        this.input1.put("inv", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.inv(variable, managerTempVariables);
            }
        });
        this.input1.put("pinv", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.pinv(variable, managerTempVariables);
            }
        });
        this.input1.put("rref", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.rref(variable, managerTempVariables);
            }
        });
        this.input1.put("eye", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.eye(variable, managerTempVariables);
            }
        });
        this.input1.put("det", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.det(variable, managerTempVariables);
            }
        });
        this.input1.put("normF", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.normF(variable, managerTempVariables);
            }
        });
        this.input1.put("trace", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.trace(variable, managerTempVariables);
            }
        });
        this.input1.put("diag", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.diag(variable, managerTempVariables);
            }
        });
        this.input1.put("min", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.min(variable, managerTempVariables);
            }
        });
        this.input1.put("max", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.max(variable, managerTempVariables);
            }
        });
        this.input1.put("abs", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.abs(variable, managerTempVariables);
            }
        });
        this.input1.put("sin", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.sin(variable, managerTempVariables);
            }
        });
        this.input1.put("cos", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.cos(variable, managerTempVariables);
            }
        });
        this.input1.put("atan", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.atan(variable, managerTempVariables);
            }
        });
        this.input1.put("exp", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.exp(variable, managerTempVariables);
            }
        });
        this.input1.put("log", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.log(variable, managerTempVariables);
            }
        });
        this.input1.put("sqrt", new Input1(){

            @Override
            public Operation.Info create(Variable variable, ManagerTempVariables managerTempVariables) {
                return Operation.sqrt(variable, managerTempVariables);
            }
        });
        this.inputN.put("zeros", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.zeros(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("ones", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.ones(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("kron", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.kron(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("dot", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.dot(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("pow", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.pow(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("atan2", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.atan2(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("solve", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 2) {
                    throw new RuntimeException("Two inputs expected");
                }
                return Operation.solve(list.get(0), list.get(1), managerTempVariables);
            }
        });
        this.inputN.put("extract", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                return Operation.extract(list, managerTempVariables);
            }
        });
        this.inputN.put("extractScalar", new InputN(){

            @Override
            public Operation.Info create(List<Variable> list, ManagerTempVariables managerTempVariables) {
                if (list.size() != 3) {
                    throw new RuntimeException("Three inputs expected");
                }
                return Operation.extractScalar(list, managerTempVariables);
            }
        });
    }

    public ManagerTempVariables getManagerTemp() {
        return this.managerTemp;
    }

    public static interface InputN {
        public Operation.Info create(List<Variable> var1, ManagerTempVariables var2);
    }

    public static interface Input1 {
        public Operation.Info create(Variable var1, ManagerTempVariables var2);
    }
}

