/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.FixedMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.ops.MatrixIO;

public class FixedMatrix2x2_64F
implements FixedMatrix64F {
    public double a11;
    public double a12;
    public double a21;
    public double a22;

    public FixedMatrix2x2_64F() {
    }

    public FixedMatrix2x2_64F(double d, double d2, double d3, double d4) {
        this.a11 = d;
        this.a12 = d2;
        this.a21 = d3;
        this.a22 = d4;
    }

    public FixedMatrix2x2_64F(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        this.a11 = fixedMatrix2x2_64F.a11;
        this.a12 = fixedMatrix2x2_64F.a12;
        this.a21 = fixedMatrix2x2_64F.a21;
        this.a22 = fixedMatrix2x2_64F.a22;
    }

    @Override
    public double get(int n, int n2) {
        return this.unsafe_get(n, n2);
    }

    @Override
    public double unsafe_get(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.a11;
            }
            if (n2 == 1) {
                return this.a12;
            }
        } else if (n == 1) {
            if (n2 == 0) {
                return this.a21;
            }
            if (n2 == 1) {
                return this.a22;
            }
        }
        throw new IllegalArgumentException("Row and/or column out of range. " + n + " " + n2);
    }

    @Override
    public void set(int n, int n2, double d) {
        this.unsafe_set(n, n2, d);
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        if (n == 0) {
            if (n2 == 0) {
                this.a11 = d;
                return;
            }
            if (n2 == 1) {
                this.a12 = d;
                return;
            }
        } else if (n == 1) {
            if (n2 == 0) {
                this.a21 = d;
                return;
            }
            if (n2 == 1) {
                this.a22 = d;
                return;
            }
        }
        throw new IllegalArgumentException("Row and/or column out of range. " + n + " " + n2);
    }

    @Override
    public void set(Matrix matrix) {
        if (matrix.getNumCols() != 2 || matrix.getNumRows() != 2) {
            throw new IllegalArgumentException("Rows and/or columns do not match");
        }
        RealMatrix64F realMatrix64F = (RealMatrix64F)matrix;
        this.a11 = realMatrix64F.get(0, 0);
        this.a12 = realMatrix64F.get(0, 1);
        this.a21 = realMatrix64F.get(1, 0);
        this.a22 = realMatrix64F.get(1, 1);
    }

    @Override
    public int getNumRows() {
        return 2;
    }

    @Override
    public int getNumCols() {
        return 2;
    }

    @Override
    public int getNumElements() {
        return 4;
    }

    @Override
    public <T extends Matrix> T copy() {
        return (T)new FixedMatrix2x2_64F(this);
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }
}

