/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.FixedMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.ops.MatrixIO;

public class FixedMatrix2_64F
implements FixedMatrix64F {
    public double a1;
    public double a2;

    public FixedMatrix2_64F() {
    }

    public FixedMatrix2_64F(double d, double d2) {
        this.a1 = d;
        this.a2 = d2;
    }

    public FixedMatrix2_64F(FixedMatrix2_64F fixedMatrix2_64F) {
        this.a1 = fixedMatrix2_64F.a1;
        this.a2 = fixedMatrix2_64F.a2;
    }

    @Override
    public double get(int n, int n2) {
        return this.unsafe_get(n, n2);
    }

    @Override
    public double unsafe_get(int n, int n2) {
        if (n != 0 && n2 != 0) {
            throw new IllegalArgumentException("Row or column must be zero since this is a vector");
        }
        int n3 = Math.max(n, n2);
        if (n3 == 0) {
            return this.a1;
        }
        if (n3 == 1) {
            return this.a2;
        }
        throw new IllegalArgumentException("Out of range.  " + n3);
    }

    @Override
    public void set(int n, int n2, double d) {
        this.unsafe_set(n, n2, d);
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        if (n != 0 && n2 != 0) {
            throw new IllegalArgumentException("Row or column must be zero since this is a vector");
        }
        int n3 = Math.max(n, n2);
        if (n3 == 0) {
            this.a1 = d;
        } else if (n3 == 1) {
            this.a2 = d;
        } else {
            throw new IllegalArgumentException("Out of range.  " + n3);
        }
    }

    @Override
    public void set(Matrix matrix) {
        RealMatrix64F realMatrix64F = (RealMatrix64F)matrix;
        if (realMatrix64F.getNumCols() == 1 && realMatrix64F.getNumRows() == 2) {
            this.a1 = realMatrix64F.get(0, 0);
            this.a2 = realMatrix64F.get(1, 0);
        } else if (realMatrix64F.getNumRows() == 1 && realMatrix64F.getNumCols() == 2) {
            this.a1 = realMatrix64F.get(0, 0);
            this.a2 = realMatrix64F.get(0, 1);
        } else {
            throw new IllegalArgumentException("Incompatible shape");
        }
    }

    @Override
    public int getNumRows() {
        return 2;
    }

    @Override
    public int getNumCols() {
        return 1;
    }

    @Override
    public int getNumElements() {
        return 2;
    }

    @Override
    public <T extends Matrix> T copy() {
        return (T)new FixedMatrix2_64F(this);
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }
}

