/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.generic;

import java.util.Random;
import org.ejml.data.RealMatrix64F;

public class GenericMatrixOps {
    public static boolean isEquivalent(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2, double d) {
        if (realMatrix64F.getNumRows() != realMatrix64F2.getNumRows() || realMatrix64F.getNumCols() != realMatrix64F2.getNumCols()) {
            return false;
        }
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                double d2 = Math.abs(realMatrix64F.get(i, j) - realMatrix64F2.get(i, j));
                if (!(d2 > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(RealMatrix64F realMatrix64F, double d) {
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                if (!(i == j ? Math.abs(realMatrix64F.get(i, j) - 1.0) > d : Math.abs(realMatrix64F.get(i, j)) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEquivalentTriangle(boolean bl, RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2, double d) {
        if (realMatrix64F.getNumRows() != realMatrix64F2.getNumRows() || realMatrix64F.getNumCols() != realMatrix64F2.getNumCols()) {
            return false;
        }
        if (bl) {
            for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
                for (int j = i; j < realMatrix64F.getNumCols(); ++j) {
                    double d2 = Math.abs(realMatrix64F.get(i, j) - realMatrix64F2.get(i, j));
                    if (!(d2 > d)) continue;
                    return false;
                }
            }
        } else {
            for (int i = 0; i < realMatrix64F.getNumCols(); ++i) {
                for (int j = i; j < realMatrix64F.getNumRows(); ++j) {
                    double d3 = Math.abs(realMatrix64F.get(j, i) - realMatrix64F2.get(j, i));
                    if (!(d3 > d)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void copy(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2) {
        int n = realMatrix64F.getNumCols();
        int n2 = realMatrix64F.getNumRows();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                realMatrix64F2.set(i, j, realMatrix64F.get(i, j));
            }
        }
    }

    public static void setRandom(RealMatrix64F realMatrix64F, double d, double d2, Random random) {
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                double d3 = random.nextDouble() * (d2 - d) + d;
                realMatrix64F.set(i, j, d3);
            }
        }
    }
}

