/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.fixed;

import org.ejml.data.FixedMatrix2_64F;
import org.ejml.data.FixedMatrix2x2_64F;

public class FixedOps2 {
    public static void add(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 + fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a12 + fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a21 + fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a22 + fixedMatrix2x2_64F2.a22;
    }

    public static void addEquals(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        fixedMatrix2x2_64F.a11 += fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F.a12 += fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F.a21 += fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F.a22 += fixedMatrix2x2_64F2.a22;
    }

    public static void subtract(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 - fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a12 - fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a21 - fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a22 - fixedMatrix2x2_64F2.a22;
    }

    public static void subtractEquals(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        fixedMatrix2x2_64F.a11 -= fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F.a12 -= fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F.a21 -= fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F.a22 -= fixedMatrix2x2_64F2.a22;
    }

    public static void transpose(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        double d = fixedMatrix2x2_64F.a12;
        fixedMatrix2x2_64F.a12 = fixedMatrix2x2_64F.a21;
        fixedMatrix2x2_64F.a21 = d;
    }

    public static FixedMatrix2x2_64F transpose(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        if (fixedMatrix2x2_64F == null) {
            fixedMatrix2x2_64F = new FixedMatrix2x2_64F();
        }
        fixedMatrix2x2_64F2.a11 = fixedMatrix2x2_64F.a11;
        fixedMatrix2x2_64F2.a12 = fixedMatrix2x2_64F.a21;
        fixedMatrix2x2_64F2.a21 = fixedMatrix2x2_64F.a12;
        fixedMatrix2x2_64F2.a22 = fixedMatrix2x2_64F.a22;
        return fixedMatrix2x2_64F2;
    }

    public static void mult(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a12 + fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a22;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a12 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a22;
    }

    public static void multTransA(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a12 + fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a22;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a12 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a22;
    }

    public static void multTransAB(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a21 + fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a22;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a21 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a22;
    }

    public static void multTransB(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a21 + fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a22;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a11 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a21 + fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a22;
    }

    public static void mult(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2_64F fixedMatrix2_64F, FixedMatrix2_64F fixedMatrix2_64F2) {
        fixedMatrix2_64F2.a1 = fixedMatrix2x2_64F.a11 * fixedMatrix2_64F.a1 + fixedMatrix2x2_64F.a12 * fixedMatrix2_64F.a2;
        fixedMatrix2_64F2.a2 = fixedMatrix2x2_64F.a21 * fixedMatrix2_64F.a1 + fixedMatrix2x2_64F.a22 * fixedMatrix2_64F.a2;
    }

    public static void mult(FixedMatrix2_64F fixedMatrix2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2_64F fixedMatrix2_64F2) {
        fixedMatrix2_64F2.a1 = fixedMatrix2_64F.a1 * fixedMatrix2x2_64F.a11 + fixedMatrix2_64F.a2 * fixedMatrix2x2_64F.a21;
        fixedMatrix2_64F2.a2 = fixedMatrix2_64F.a1 * fixedMatrix2x2_64F.a12 + fixedMatrix2_64F.a2 * fixedMatrix2x2_64F.a22;
    }

    public static double dot(FixedMatrix2_64F fixedMatrix2_64F, FixedMatrix2_64F fixedMatrix2_64F2) {
        return fixedMatrix2_64F.a1 * fixedMatrix2_64F2.a1 + fixedMatrix2_64F.a2 * fixedMatrix2_64F2.a2;
    }

    public static void setIdentity(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        fixedMatrix2x2_64F.a11 = 1.0;
        fixedMatrix2x2_64F.a21 = 0.0;
        fixedMatrix2x2_64F.a12 = 0.0;
        fixedMatrix2x2_64F.a22 = 1.0;
    }

    public static boolean invert(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        double d;
        double d2 = 1.0 / FixedOps2.elementMaxAbs(fixedMatrix2x2_64F);
        double d3 = fixedMatrix2x2_64F.a11 * d2;
        double d4 = fixedMatrix2x2_64F.a12 * d2;
        double d5 = fixedMatrix2x2_64F.a21 * d2;
        double d6 = d = fixedMatrix2x2_64F.a22 * d2;
        double d7 = -d5;
        double d8 = -d4;
        double d9 = d3;
        double d10 = (d3 * d6 + d4 * d7) / d2;
        fixedMatrix2x2_64F2.a11 = d6 / d10;
        fixedMatrix2x2_64F2.a12 = d8 / d10;
        fixedMatrix2x2_64F2.a21 = d7 / d10;
        fixedMatrix2x2_64F2.a22 = d9 / d10;
        return !Double.isNaN(d10) && !Double.isInfinite(d10);
    }

    public static double det(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        return fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F.a22 - fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F.a21;
    }

    public static double trace(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        return fixedMatrix2x2_64F.a11 + fixedMatrix2x2_64F.a21;
    }

    public static void diag(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2_64F fixedMatrix2_64F) {
        fixedMatrix2_64F.a1 = fixedMatrix2x2_64F.a11;
        fixedMatrix2_64F.a2 = fixedMatrix2x2_64F.a22;
    }

    public static double elementMax(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        double d = fixedMatrix2x2_64F.a11;
        d = Math.max(d, fixedMatrix2x2_64F.a12);
        d = Math.max(d, fixedMatrix2x2_64F.a21);
        d = Math.max(d, fixedMatrix2x2_64F.a22);
        return d;
    }

    public static double elementMaxAbs(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        double d = fixedMatrix2x2_64F.a11;
        d = Math.max(d, Math.abs(fixedMatrix2x2_64F.a12));
        d = Math.max(d, Math.abs(fixedMatrix2x2_64F.a21));
        d = Math.max(d, Math.abs(fixedMatrix2x2_64F.a22));
        return d;
    }

    public static double elementMin(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        double d = fixedMatrix2x2_64F.a11;
        d = Math.min(d, fixedMatrix2x2_64F.a12);
        d = Math.min(d, fixedMatrix2x2_64F.a21);
        d = Math.min(d, fixedMatrix2x2_64F.a22);
        return d;
    }

    public static double elementMinAbs(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        double d = fixedMatrix2x2_64F.a11;
        d = Math.min(d, Math.abs(fixedMatrix2x2_64F.a12));
        d = Math.min(d, Math.abs(fixedMatrix2x2_64F.a21));
        d = Math.min(d, Math.abs(fixedMatrix2x2_64F.a22));
        return d;
    }

    public static void elementMult(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        fixedMatrix2x2_64F.a11 *= fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F.a12 *= fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F.a21 *= fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F.a22 *= fixedMatrix2x2_64F2.a22;
    }

    public static void elementMult(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 * fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a12 * fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a21 * fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a22 * fixedMatrix2x2_64F2.a22;
    }

    public static void elementDiv(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        fixedMatrix2x2_64F.a11 /= fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F.a12 /= fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F.a21 /= fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F.a22 /= fixedMatrix2x2_64F2.a22;
    }

    public static void elementDiv(FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2, FixedMatrix2x2_64F fixedMatrix2x2_64F3) {
        fixedMatrix2x2_64F3.a11 = fixedMatrix2x2_64F.a11 / fixedMatrix2x2_64F2.a11;
        fixedMatrix2x2_64F3.a12 = fixedMatrix2x2_64F.a12 / fixedMatrix2x2_64F2.a12;
        fixedMatrix2x2_64F3.a21 = fixedMatrix2x2_64F.a21 / fixedMatrix2x2_64F2.a21;
        fixedMatrix2x2_64F3.a22 = fixedMatrix2x2_64F.a22 / fixedMatrix2x2_64F2.a22;
    }

    public static void scale(double d, FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        fixedMatrix2x2_64F.a11 *= d;
        fixedMatrix2x2_64F.a12 *= d;
        fixedMatrix2x2_64F.a21 *= d;
        fixedMatrix2x2_64F.a22 *= d;
    }

    public static void scale(double d, FixedMatrix2x2_64F fixedMatrix2x2_64F, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        fixedMatrix2x2_64F2.a11 = fixedMatrix2x2_64F.a11 * d;
        fixedMatrix2x2_64F2.a12 = fixedMatrix2x2_64F.a12 * d;
        fixedMatrix2x2_64F2.a21 = fixedMatrix2x2_64F.a21 * d;
        fixedMatrix2x2_64F2.a22 = fixedMatrix2x2_64F.a22 * d;
    }

    public static void divide(FixedMatrix2x2_64F fixedMatrix2x2_64F, double d) {
        fixedMatrix2x2_64F.a11 /= d;
        fixedMatrix2x2_64F.a12 /= d;
        fixedMatrix2x2_64F.a21 /= d;
        fixedMatrix2x2_64F.a22 /= d;
    }

    public static void divide(FixedMatrix2x2_64F fixedMatrix2x2_64F, double d, FixedMatrix2x2_64F fixedMatrix2x2_64F2) {
        fixedMatrix2x2_64F2.a11 = fixedMatrix2x2_64F.a11 / d;
        fixedMatrix2x2_64F2.a12 = fixedMatrix2x2_64F.a12 / d;
        fixedMatrix2x2_64F2.a21 = fixedMatrix2x2_64F.a21 / d;
        fixedMatrix2x2_64F2.a22 = fixedMatrix2x2_64F.a22 / d;
    }

    public static void changeSign(FixedMatrix2x2_64F fixedMatrix2x2_64F) {
        fixedMatrix2x2_64F.a11 = -fixedMatrix2x2_64F.a11;
        fixedMatrix2x2_64F.a12 = -fixedMatrix2x2_64F.a12;
        fixedMatrix2x2_64F.a21 = -fixedMatrix2x2_64F.a21;
        fixedMatrix2x2_64F.a22 = -fixedMatrix2x2_64F.a22;
    }

    public static void fill(FixedMatrix2x2_64F fixedMatrix2x2_64F, double d) {
        fixedMatrix2x2_64F.a11 = d;
        fixedMatrix2x2_64F.a12 = d;
        fixedMatrix2x2_64F.a21 = d;
        fixedMatrix2x2_64F.a22 = d;
    }

    public static FixedMatrix2_64F extractRow(FixedMatrix2x2_64F fixedMatrix2x2_64F, int n, FixedMatrix2_64F fixedMatrix2_64F) {
        if (fixedMatrix2_64F == null) {
            fixedMatrix2_64F = new FixedMatrix2_64F();
        }
        switch (n) {
            case 0: {
                fixedMatrix2_64F.a1 = fixedMatrix2x2_64F.a11;
                fixedMatrix2_64F.a2 = fixedMatrix2x2_64F.a12;
                break;
            }
            case 1: {
                fixedMatrix2_64F.a1 = fixedMatrix2x2_64F.a21;
                fixedMatrix2_64F.a2 = fixedMatrix2x2_64F.a22;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds row.  row = " + n);
            }
        }
        return fixedMatrix2_64F;
    }

    public static FixedMatrix2_64F extractColumn(FixedMatrix2x2_64F fixedMatrix2x2_64F, int n, FixedMatrix2_64F fixedMatrix2_64F) {
        if (fixedMatrix2_64F == null) {
            fixedMatrix2_64F = new FixedMatrix2_64F();
        }
        switch (n) {
            case 0: {
                fixedMatrix2_64F.a1 = fixedMatrix2x2_64F.a11;
                fixedMatrix2_64F.a2 = fixedMatrix2x2_64F.a21;
                break;
            }
            case 1: {
                fixedMatrix2_64F.a1 = fixedMatrix2x2_64F.a12;
                fixedMatrix2_64F.a2 = fixedMatrix2x2_64F.a22;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds column.  column = " + n);
            }
        }
        return fixedMatrix2_64F;
    }
}

