/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.densed2.mult;

import org.ejml.data.DenseD2Matrix64F;
import org.ejml.ops.MatrixDimensionException;

public class MatrixMatrixMult_D2 {
    public static void mult_small(DenseD2Matrix64F denseD2Matrix64F, DenseD2Matrix64F denseD2Matrix64F2, DenseD2Matrix64F denseD2Matrix64F3) {
        if (denseD2Matrix64F.numCols != denseD2Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (denseD2Matrix64F.numRows != denseD2Matrix64F3.numRows || denseD2Matrix64F2.numCols != denseD2Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        double[][] dArray = denseD2Matrix64F.data;
        double[][] dArray2 = denseD2Matrix64F2.data;
        double[][] dArray3 = denseD2Matrix64F3.data;
        for (int i = 0; i < denseD2Matrix64F.numRows; ++i) {
            double[] dArray4 = dArray[i];
            double[] dArray5 = dArray3[i];
            for (int j = 0; j < denseD2Matrix64F2.numCols; ++j) {
                double d = 0.0;
                for (int k = 0; k < denseD2Matrix64F.numCols; ++k) {
                    d += dArray4[k] * dArray2[k][j];
                }
                dArray5[j] = d;
            }
        }
    }

    public static void mult_aux(DenseD2Matrix64F denseD2Matrix64F, DenseD2Matrix64F denseD2Matrix64F2, DenseD2Matrix64F denseD2Matrix64F3, double[] dArray) {
        if (denseD2Matrix64F.numCols != denseD2Matrix64F2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (denseD2Matrix64F.numRows != denseD2Matrix64F3.numRows || denseD2Matrix64F2.numCols != denseD2Matrix64F3.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (dArray == null) {
            dArray = new double[denseD2Matrix64F2.numRows];
        }
        double[][] dArray2 = denseD2Matrix64F.data;
        double[][] dArray3 = denseD2Matrix64F2.data;
        double[][] dArray4 = denseD2Matrix64F3.data;
        for (int i = 0; i < denseD2Matrix64F2.numCols; ++i) {
            int n;
            for (n = 0; n < denseD2Matrix64F2.numRows; ++n) {
                dArray[n] = dArray3[n][i];
            }
            for (n = 0; n < denseD2Matrix64F.numRows; ++n) {
                double[] dArray5 = dArray2[n];
                double d = 0.0;
                int n2 = 0;
                while (n2 < denseD2Matrix64F2.numRows) {
                    d += dArray5[n2] * dArray[n2++];
                }
                dArray4[n][i] = d;
            }
        }
    }
}

