/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;

public class CVectorVectorMult {
    public static Complex64F innerProd(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, Complex64F complex64F) {
        if (complex64F == null) {
            complex64F = new Complex64F();
        } else {
            complex64F.imaginary = 0.0;
            complex64F.real = 0.0;
        }
        int n = cDenseMatrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            double d = cDenseMatrix64F.data[i];
            double d2 = cDenseMatrix64F.data[i + 1];
            double d3 = cDenseMatrix64F2.data[i];
            double d4 = cDenseMatrix64F2.data[i + 1];
            complex64F.real += d * d3 - d2 * d4;
            complex64F.imaginary += d * d4 + d2 * d3;
        }
        return complex64F;
    }

    public static Complex64F innerProdH(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, Complex64F complex64F) {
        if (complex64F == null) {
            complex64F = new Complex64F();
        } else {
            complex64F.imaginary = 0.0;
            complex64F.real = 0.0;
        }
        int n = cDenseMatrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            double d = cDenseMatrix64F.data[i];
            double d2 = cDenseMatrix64F.data[i + 1];
            double d3 = cDenseMatrix64F2.data[i];
            double d4 = -cDenseMatrix64F2.data[i + 1];
            complex64F.real += d * d3 - d2 * d4;
            complex64F.imaginary += d * d4 + d2 * d3;
        }
        return complex64F;
    }

    public static void outerProd(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        int n = cDenseMatrix64F3.numRows;
        int n2 = cDenseMatrix64F3.numCols;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d = cDenseMatrix64F.data[i * 2];
            double d2 = cDenseMatrix64F.data[i * 2 + 1];
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                double d3 = cDenseMatrix64F2.data[n4++];
                double d4 = cDenseMatrix64F2.data[n4++];
                cDenseMatrix64F3.data[n3++] = d * d3 - d2 * d4;
                cDenseMatrix64F3.data[n3++] = d * d4 + d2 * d3;
            }
        }
    }

    public static void outerProdH(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        int n = cDenseMatrix64F3.numRows;
        int n2 = cDenseMatrix64F3.numCols;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d = cDenseMatrix64F.data[i * 2];
            double d2 = cDenseMatrix64F.data[i * 2 + 1];
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                double d3 = cDenseMatrix64F2.data[n4++];
                double d4 = -cDenseMatrix64F2.data[n4++];
                cDenseMatrix64F3.data[n3++] = d * d3 - d2 * d4;
                cDenseMatrix64F3.data[n3++] = d * d4 + d2 * d3;
            }
        }
    }
}

