/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.data.DenseMatrix64F;

public class UnrolledInverseFromMinor {
    public static final int MAX = 5;

    public static void inv(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        double d = Math.abs(denseMatrix64F.data[0]);
        int n = denseMatrix64F.getNumElements();
        for (int i = 1; i < n; ++i) {
            double d2 = Math.abs(denseMatrix64F.data[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        switch (denseMatrix64F.numRows) {
            case 2: {
                UnrolledInverseFromMinor.inv2(denseMatrix64F, denseMatrix64F2, 1.0 / d);
                break;
            }
            case 3: {
                UnrolledInverseFromMinor.inv3(denseMatrix64F, denseMatrix64F2, 1.0 / d);
                break;
            }
            case 4: {
                UnrolledInverseFromMinor.inv4(denseMatrix64F, denseMatrix64F2, 1.0 / d);
                break;
            }
            case 5: {
                UnrolledInverseFromMinor.inv5(denseMatrix64F, denseMatrix64F2, 1.0 / d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported");
            }
        }
    }

    public static void inv2(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, double d) {
        double d2;
        double[] dArray = denseMatrix64F.data;
        double d3 = dArray[0] * d;
        double d4 = dArray[1] * d;
        double d5 = dArray[2] * d;
        double d6 = d2 = dArray[3] * d;
        double d7 = -d5;
        double d8 = -d4;
        double d9 = d3;
        double d10 = (d3 * d6 + d4 * d7) / d;
        dArray = denseMatrix64F2.data;
        dArray[0] = d6 / d10;
        dArray[1] = d8 / d10;
        dArray[2] = d7 / d10;
        dArray[3] = d9 / d10;
    }

    public static void inv3(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, double d) {
        double[] dArray = denseMatrix64F.data;
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        double d4 = dArray[2] * d;
        double d5 = dArray[3] * d;
        double d6 = dArray[4] * d;
        double d7 = dArray[5] * d;
        double d8 = dArray[6] * d;
        double d9 = dArray[7] * d;
        double d10 = dArray[8] * d;
        double d11 = d6 * d10 - d7 * d9;
        double d12 = -(d5 * d10 - d7 * d8);
        double d13 = d5 * d9 - d6 * d8;
        double d14 = -(d3 * d10 - d4 * d9);
        double d15 = d2 * d10 - d4 * d8;
        double d16 = -(d2 * d9 - d3 * d8);
        double d17 = d3 * d7 - d4 * d6;
        double d18 = -(d2 * d7 - d4 * d5);
        double d19 = d2 * d6 - d3 * d5;
        double d20 = (d2 * d11 + d3 * d12 + d4 * d13) / d;
        dArray = denseMatrix64F2.data;
        dArray[0] = d11 / d20;
        dArray[1] = d14 / d20;
        dArray[2] = d17 / d20;
        dArray[3] = d12 / d20;
        dArray[4] = d15 / d20;
        dArray[5] = d18 / d20;
        dArray[6] = d13 / d20;
        dArray[7] = d16 / d20;
        dArray[8] = d19 / d20;
    }

    public static void inv4(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, double d) {
        double[] dArray = denseMatrix64F.data;
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        double d4 = dArray[2] * d;
        double d5 = dArray[3] * d;
        double d6 = dArray[4] * d;
        double d7 = dArray[5] * d;
        double d8 = dArray[6] * d;
        double d9 = dArray[7] * d;
        double d10 = dArray[8] * d;
        double d11 = dArray[9] * d;
        double d12 = dArray[10] * d;
        double d13 = dArray[11] * d;
        double d14 = dArray[12] * d;
        double d15 = dArray[13] * d;
        double d16 = dArray[14] * d;
        double d17 = dArray[15] * d;
        double d18 = d7 * (d12 * d17 - d13 * d16) - d8 * (d11 * d17 - d13 * d15) + d9 * (d11 * d16 - d12 * d15);
        double d19 = -(d6 * (d12 * d17 - d13 * d16) - d8 * (d10 * d17 - d13 * d14) + d9 * (d10 * d16 - d12 * d14));
        double d20 = d6 * (d11 * d17 - d13 * d15) - d7 * (d10 * d17 - d13 * d14) + d9 * (d10 * d15 - d11 * d14);
        double d21 = -(d6 * (d11 * d16 - d12 * d15) - d7 * (d10 * d16 - d12 * d14) + d8 * (d10 * d15 - d11 * d14));
        double d22 = -(d3 * (d12 * d17 - d13 * d16) - d4 * (d11 * d17 - d13 * d15) + d5 * (d11 * d16 - d12 * d15));
        double d23 = d2 * (d12 * d17 - d13 * d16) - d4 * (d10 * d17 - d13 * d14) + d5 * (d10 * d16 - d12 * d14);
        double d24 = -(d2 * (d11 * d17 - d13 * d15) - d3 * (d10 * d17 - d13 * d14) + d5 * (d10 * d15 - d11 * d14));
        double d25 = d2 * (d11 * d16 - d12 * d15) - d3 * (d10 * d16 - d12 * d14) + d4 * (d10 * d15 - d11 * d14);
        double d26 = d3 * (d8 * d17 - d9 * d16) - d4 * (d7 * d17 - d9 * d15) + d5 * (d7 * d16 - d8 * d15);
        double d27 = -(d2 * (d8 * d17 - d9 * d16) - d4 * (d6 * d17 - d9 * d14) + d5 * (d6 * d16 - d8 * d14));
        double d28 = d2 * (d7 * d17 - d9 * d15) - d3 * (d6 * d17 - d9 * d14) + d5 * (d6 * d15 - d7 * d14);
        double d29 = -(d2 * (d7 * d16 - d8 * d15) - d3 * (d6 * d16 - d8 * d14) + d4 * (d6 * d15 - d7 * d14));
        double d30 = -(d3 * (d8 * d13 - d9 * d12) - d4 * (d7 * d13 - d9 * d11) + d5 * (d7 * d12 - d8 * d11));
        double d31 = d2 * (d8 * d13 - d9 * d12) - d4 * (d6 * d13 - d9 * d10) + d5 * (d6 * d12 - d8 * d10);
        double d32 = -(d2 * (d7 * d13 - d9 * d11) - d3 * (d6 * d13 - d9 * d10) + d5 * (d6 * d11 - d7 * d10));
        double d33 = d2 * (d7 * d12 - d8 * d11) - d3 * (d6 * d12 - d8 * d10) + d4 * (d6 * d11 - d7 * d10);
        double d34 = (d2 * d18 + d3 * d19 + d4 * d20 + d5 * d21) / d;
        dArray = denseMatrix64F2.data;
        dArray[0] = d18 / d34;
        dArray[1] = d22 / d34;
        dArray[2] = d26 / d34;
        dArray[3] = d30 / d34;
        dArray[4] = d19 / d34;
        dArray[5] = d23 / d34;
        dArray[6] = d27 / d34;
        dArray[7] = d31 / d34;
        dArray[8] = d20 / d34;
        dArray[9] = d24 / d34;
        dArray[10] = d28 / d34;
        dArray[11] = d32 / d34;
        dArray[12] = d21 / d34;
        dArray[13] = d25 / d34;
        dArray[14] = d29 / d34;
        dArray[15] = d33 / d34;
    }

    public static void inv5(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, double d) {
        double[] dArray = denseMatrix64F.data;
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        double d4 = dArray[2] * d;
        double d5 = dArray[3] * d;
        double d6 = dArray[4] * d;
        double d7 = dArray[5] * d;
        double d8 = dArray[6] * d;
        double d9 = dArray[7] * d;
        double d10 = dArray[8] * d;
        double d11 = dArray[9] * d;
        double d12 = dArray[10] * d;
        double d13 = dArray[11] * d;
        double d14 = dArray[12] * d;
        double d15 = dArray[13] * d;
        double d16 = dArray[14] * d;
        double d17 = dArray[15] * d;
        double d18 = dArray[16] * d;
        double d19 = dArray[17] * d;
        double d20 = dArray[18] * d;
        double d21 = dArray[19] * d;
        double d22 = dArray[20] * d;
        double d23 = dArray[21] * d;
        double d24 = dArray[22] * d;
        double d25 = dArray[23] * d;
        double d26 = dArray[24] * d;
        double d27 = d8 * (d14 * (d20 * d26 - d21 * d25) - d15 * (d19 * d26 - d21 * d24) + d16 * (d19 * d25 - d20 * d24)) - d9 * (d13 * (d20 * d26 - d21 * d25) - d15 * (d18 * d26 - d21 * d23) + d16 * (d18 * d25 - d20 * d23)) + d10 * (d13 * (d19 * d26 - d21 * d24) - d14 * (d18 * d26 - d21 * d23) + d16 * (d18 * d24 - d19 * d23)) - d11 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23));
        double d28 = -(d7 * (d14 * (d20 * d26 - d21 * d25) - d15 * (d19 * d26 - d21 * d24) + d16 * (d19 * d25 - d20 * d24)) - d9 * (d12 * (d20 * d26 - d21 * d25) - d15 * (d17 * d26 - d21 * d22) + d16 * (d17 * d25 - d20 * d22)) + d10 * (d12 * (d19 * d26 - d21 * d24) - d14 * (d17 * d26 - d21 * d22) + d16 * (d17 * d24 - d19 * d22)) - d11 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)));
        double d29 = d7 * (d13 * (d20 * d26 - d21 * d25) - d15 * (d18 * d26 - d21 * d23) + d16 * (d18 * d25 - d20 * d23)) - d8 * (d12 * (d20 * d26 - d21 * d25) - d15 * (d17 * d26 - d21 * d22) + d16 * (d17 * d25 - d20 * d22)) + d10 * (d12 * (d18 * d26 - d21 * d23) - d13 * (d17 * d26 - d21 * d22) + d16 * (d17 * d23 - d18 * d22)) - d11 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22));
        double d30 = -(d7 * (d13 * (d19 * d26 - d21 * d24) - d14 * (d18 * d26 - d21 * d23) + d16 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d26 - d21 * d24) - d14 * (d17 * d26 - d21 * d22) + d16 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d26 - d21 * d23) - d13 * (d17 * d26 - d21 * d22) + d16 * (d17 * d23 - d18 * d22)) - d11 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)));
        double d31 = d7 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d8 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d9 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d10 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22));
        double d32 = -(d3 * (d14 * (d20 * d26 - d21 * d25) - d15 * (d19 * d26 - d21 * d24) + d16 * (d19 * d25 - d20 * d24)) - d4 * (d13 * (d20 * d26 - d21 * d25) - d15 * (d18 * d26 - d21 * d23) + d16 * (d18 * d25 - d20 * d23)) + d5 * (d13 * (d19 * d26 - d21 * d24) - d14 * (d18 * d26 - d21 * d23) + d16 * (d18 * d24 - d19 * d23)) - d6 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)));
        double d33 = d2 * (d14 * (d20 * d26 - d21 * d25) - d15 * (d19 * d26 - d21 * d24) + d16 * (d19 * d25 - d20 * d24)) - d4 * (d12 * (d20 * d26 - d21 * d25) - d15 * (d17 * d26 - d21 * d22) + d16 * (d17 * d25 - d20 * d22)) + d5 * (d12 * (d19 * d26 - d21 * d24) - d14 * (d17 * d26 - d21 * d22) + d16 * (d17 * d24 - d19 * d22)) - d6 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22));
        double d34 = -(d2 * (d13 * (d20 * d26 - d21 * d25) - d15 * (d18 * d26 - d21 * d23) + d16 * (d18 * d25 - d20 * d23)) - d3 * (d12 * (d20 * d26 - d21 * d25) - d15 * (d17 * d26 - d21 * d22) + d16 * (d17 * d25 - d20 * d22)) + d5 * (d12 * (d18 * d26 - d21 * d23) - d13 * (d17 * d26 - d21 * d22) + d16 * (d17 * d23 - d18 * d22)) - d6 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)));
        double d35 = d2 * (d13 * (d19 * d26 - d21 * d24) - d14 * (d18 * d26 - d21 * d23) + d16 * (d18 * d24 - d19 * d23)) - d3 * (d12 * (d19 * d26 - d21 * d24) - d14 * (d17 * d26 - d21 * d22) + d16 * (d17 * d24 - d19 * d22)) + d4 * (d12 * (d18 * d26 - d21 * d23) - d13 * (d17 * d26 - d21 * d22) + d16 * (d17 * d23 - d18 * d22)) - d6 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22));
        double d36 = -(d2 * (d13 * (d19 * d25 - d20 * d24) - d14 * (d18 * d25 - d20 * d23) + d15 * (d18 * d24 - d19 * d23)) - d3 * (d12 * (d19 * d25 - d20 * d24) - d14 * (d17 * d25 - d20 * d22) + d15 * (d17 * d24 - d19 * d22)) + d4 * (d12 * (d18 * d25 - d20 * d23) - d13 * (d17 * d25 - d20 * d22) + d15 * (d17 * d23 - d18 * d22)) - d5 * (d12 * (d18 * d24 - d19 * d23) - d13 * (d17 * d24 - d19 * d22) + d14 * (d17 * d23 - d18 * d22)));
        double d37 = d3 * (d9 * (d20 * d26 - d21 * d25) - d10 * (d19 * d26 - d21 * d24) + d11 * (d19 * d25 - d20 * d24)) - d4 * (d8 * (d20 * d26 - d21 * d25) - d10 * (d18 * d26 - d21 * d23) + d11 * (d18 * d25 - d20 * d23)) + d5 * (d8 * (d19 * d26 - d21 * d24) - d9 * (d18 * d26 - d21 * d23) + d11 * (d18 * d24 - d19 * d23)) - d6 * (d8 * (d19 * d25 - d20 * d24) - d9 * (d18 * d25 - d20 * d23) + d10 * (d18 * d24 - d19 * d23));
        double d38 = -(d2 * (d9 * (d20 * d26 - d21 * d25) - d10 * (d19 * d26 - d21 * d24) + d11 * (d19 * d25 - d20 * d24)) - d4 * (d7 * (d20 * d26 - d21 * d25) - d10 * (d17 * d26 - d21 * d22) + d11 * (d17 * d25 - d20 * d22)) + d5 * (d7 * (d19 * d26 - d21 * d24) - d9 * (d17 * d26 - d21 * d22) + d11 * (d17 * d24 - d19 * d22)) - d6 * (d7 * (d19 * d25 - d20 * d24) - d9 * (d17 * d25 - d20 * d22) + d10 * (d17 * d24 - d19 * d22)));
        double d39 = d2 * (d8 * (d20 * d26 - d21 * d25) - d10 * (d18 * d26 - d21 * d23) + d11 * (d18 * d25 - d20 * d23)) - d3 * (d7 * (d20 * d26 - d21 * d25) - d10 * (d17 * d26 - d21 * d22) + d11 * (d17 * d25 - d20 * d22)) + d5 * (d7 * (d18 * d26 - d21 * d23) - d8 * (d17 * d26 - d21 * d22) + d11 * (d17 * d23 - d18 * d22)) - d6 * (d7 * (d18 * d25 - d20 * d23) - d8 * (d17 * d25 - d20 * d22) + d10 * (d17 * d23 - d18 * d22));
        double d40 = -(d2 * (d8 * (d19 * d26 - d21 * d24) - d9 * (d18 * d26 - d21 * d23) + d11 * (d18 * d24 - d19 * d23)) - d3 * (d7 * (d19 * d26 - d21 * d24) - d9 * (d17 * d26 - d21 * d22) + d11 * (d17 * d24 - d19 * d22)) + d4 * (d7 * (d18 * d26 - d21 * d23) - d8 * (d17 * d26 - d21 * d22) + d11 * (d17 * d23 - d18 * d22)) - d6 * (d7 * (d18 * d24 - d19 * d23) - d8 * (d17 * d24 - d19 * d22) + d9 * (d17 * d23 - d18 * d22)));
        double d41 = d2 * (d8 * (d19 * d25 - d20 * d24) - d9 * (d18 * d25 - d20 * d23) + d10 * (d18 * d24 - d19 * d23)) - d3 * (d7 * (d19 * d25 - d20 * d24) - d9 * (d17 * d25 - d20 * d22) + d10 * (d17 * d24 - d19 * d22)) + d4 * (d7 * (d18 * d25 - d20 * d23) - d8 * (d17 * d25 - d20 * d22) + d10 * (d17 * d23 - d18 * d22)) - d5 * (d7 * (d18 * d24 - d19 * d23) - d8 * (d17 * d24 - d19 * d22) + d9 * (d17 * d23 - d18 * d22));
        double d42 = -(d3 * (d9 * (d15 * d26 - d16 * d25) - d10 * (d14 * d26 - d16 * d24) + d11 * (d14 * d25 - d15 * d24)) - d4 * (d8 * (d15 * d26 - d16 * d25) - d10 * (d13 * d26 - d16 * d23) + d11 * (d13 * d25 - d15 * d23)) + d5 * (d8 * (d14 * d26 - d16 * d24) - d9 * (d13 * d26 - d16 * d23) + d11 * (d13 * d24 - d14 * d23)) - d6 * (d8 * (d14 * d25 - d15 * d24) - d9 * (d13 * d25 - d15 * d23) + d10 * (d13 * d24 - d14 * d23)));
        double d43 = d2 * (d9 * (d15 * d26 - d16 * d25) - d10 * (d14 * d26 - d16 * d24) + d11 * (d14 * d25 - d15 * d24)) - d4 * (d7 * (d15 * d26 - d16 * d25) - d10 * (d12 * d26 - d16 * d22) + d11 * (d12 * d25 - d15 * d22)) + d5 * (d7 * (d14 * d26 - d16 * d24) - d9 * (d12 * d26 - d16 * d22) + d11 * (d12 * d24 - d14 * d22)) - d6 * (d7 * (d14 * d25 - d15 * d24) - d9 * (d12 * d25 - d15 * d22) + d10 * (d12 * d24 - d14 * d22));
        double d44 = -(d2 * (d8 * (d15 * d26 - d16 * d25) - d10 * (d13 * d26 - d16 * d23) + d11 * (d13 * d25 - d15 * d23)) - d3 * (d7 * (d15 * d26 - d16 * d25) - d10 * (d12 * d26 - d16 * d22) + d11 * (d12 * d25 - d15 * d22)) + d5 * (d7 * (d13 * d26 - d16 * d23) - d8 * (d12 * d26 - d16 * d22) + d11 * (d12 * d23 - d13 * d22)) - d6 * (d7 * (d13 * d25 - d15 * d23) - d8 * (d12 * d25 - d15 * d22) + d10 * (d12 * d23 - d13 * d22)));
        double d45 = d2 * (d8 * (d14 * d26 - d16 * d24) - d9 * (d13 * d26 - d16 * d23) + d11 * (d13 * d24 - d14 * d23)) - d3 * (d7 * (d14 * d26 - d16 * d24) - d9 * (d12 * d26 - d16 * d22) + d11 * (d12 * d24 - d14 * d22)) + d4 * (d7 * (d13 * d26 - d16 * d23) - d8 * (d12 * d26 - d16 * d22) + d11 * (d12 * d23 - d13 * d22)) - d6 * (d7 * (d13 * d24 - d14 * d23) - d8 * (d12 * d24 - d14 * d22) + d9 * (d12 * d23 - d13 * d22));
        double d46 = -(d2 * (d8 * (d14 * d25 - d15 * d24) - d9 * (d13 * d25 - d15 * d23) + d10 * (d13 * d24 - d14 * d23)) - d3 * (d7 * (d14 * d25 - d15 * d24) - d9 * (d12 * d25 - d15 * d22) + d10 * (d12 * d24 - d14 * d22)) + d4 * (d7 * (d13 * d25 - d15 * d23) - d8 * (d12 * d25 - d15 * d22) + d10 * (d12 * d23 - d13 * d22)) - d5 * (d7 * (d13 * d24 - d14 * d23) - d8 * (d12 * d24 - d14 * d22) + d9 * (d12 * d23 - d13 * d22)));
        double d47 = d3 * (d9 * (d15 * d21 - d16 * d20) - d10 * (d14 * d21 - d16 * d19) + d11 * (d14 * d20 - d15 * d19)) - d4 * (d8 * (d15 * d21 - d16 * d20) - d10 * (d13 * d21 - d16 * d18) + d11 * (d13 * d20 - d15 * d18)) + d5 * (d8 * (d14 * d21 - d16 * d19) - d9 * (d13 * d21 - d16 * d18) + d11 * (d13 * d19 - d14 * d18)) - d6 * (d8 * (d14 * d20 - d15 * d19) - d9 * (d13 * d20 - d15 * d18) + d10 * (d13 * d19 - d14 * d18));
        double d48 = -(d2 * (d9 * (d15 * d21 - d16 * d20) - d10 * (d14 * d21 - d16 * d19) + d11 * (d14 * d20 - d15 * d19)) - d4 * (d7 * (d15 * d21 - d16 * d20) - d10 * (d12 * d21 - d16 * d17) + d11 * (d12 * d20 - d15 * d17)) + d5 * (d7 * (d14 * d21 - d16 * d19) - d9 * (d12 * d21 - d16 * d17) + d11 * (d12 * d19 - d14 * d17)) - d6 * (d7 * (d14 * d20 - d15 * d19) - d9 * (d12 * d20 - d15 * d17) + d10 * (d12 * d19 - d14 * d17)));
        double d49 = d2 * (d8 * (d15 * d21 - d16 * d20) - d10 * (d13 * d21 - d16 * d18) + d11 * (d13 * d20 - d15 * d18)) - d3 * (d7 * (d15 * d21 - d16 * d20) - d10 * (d12 * d21 - d16 * d17) + d11 * (d12 * d20 - d15 * d17)) + d5 * (d7 * (d13 * d21 - d16 * d18) - d8 * (d12 * d21 - d16 * d17) + d11 * (d12 * d18 - d13 * d17)) - d6 * (d7 * (d13 * d20 - d15 * d18) - d8 * (d12 * d20 - d15 * d17) + d10 * (d12 * d18 - d13 * d17));
        double d50 = -(d2 * (d8 * (d14 * d21 - d16 * d19) - d9 * (d13 * d21 - d16 * d18) + d11 * (d13 * d19 - d14 * d18)) - d3 * (d7 * (d14 * d21 - d16 * d19) - d9 * (d12 * d21 - d16 * d17) + d11 * (d12 * d19 - d14 * d17)) + d4 * (d7 * (d13 * d21 - d16 * d18) - d8 * (d12 * d21 - d16 * d17) + d11 * (d12 * d18 - d13 * d17)) - d6 * (d7 * (d13 * d19 - d14 * d18) - d8 * (d12 * d19 - d14 * d17) + d9 * (d12 * d18 - d13 * d17)));
        double d51 = d2 * (d8 * (d14 * d20 - d15 * d19) - d9 * (d13 * d20 - d15 * d18) + d10 * (d13 * d19 - d14 * d18)) - d3 * (d7 * (d14 * d20 - d15 * d19) - d9 * (d12 * d20 - d15 * d17) + d10 * (d12 * d19 - d14 * d17)) + d4 * (d7 * (d13 * d20 - d15 * d18) - d8 * (d12 * d20 - d15 * d17) + d10 * (d12 * d18 - d13 * d17)) - d5 * (d7 * (d13 * d19 - d14 * d18) - d8 * (d12 * d19 - d14 * d17) + d9 * (d12 * d18 - d13 * d17));
        double d52 = (d2 * d27 + d3 * d28 + d4 * d29 + d5 * d30 + d6 * d31) / d;
        dArray = denseMatrix64F2.data;
        dArray[0] = d27 / d52;
        dArray[1] = d32 / d52;
        dArray[2] = d37 / d52;
        dArray[3] = d42 / d52;
        dArray[4] = d47 / d52;
        dArray[5] = d28 / d52;
        dArray[6] = d33 / d52;
        dArray[7] = d38 / d52;
        dArray[8] = d43 / d52;
        dArray[9] = d48 / d52;
        dArray[10] = d29 / d52;
        dArray[11] = d34 / d52;
        dArray[12] = d39 / d52;
        dArray[13] = d44 / d52;
        dArray[14] = d49 / d52;
        dArray[15] = d30 / d52;
        dArray[16] = d35 / d52;
        dArray[17] = d40 / d52;
        dArray[18] = d45 / d52;
        dArray[19] = d50 / d52;
        dArray[20] = d31 / d52;
        dArray[21] = d36 / d52;
        dArray[22] = d41 / d52;
        dArray[23] = d46 / d52;
        dArray[24] = d51 / d52;
    }
}

