/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.svd;

import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class SolvePseudoInverseSvd
implements LinearSolver<DenseMatrix64F> {
    private SingularValueDecomposition<DenseMatrix64F> svd;
    private DenseMatrix64F pinv = new DenseMatrix64F(1, 1);
    private double threshold = UtilEjml.EPS;

    public SolvePseudoInverseSvd(int n, int n2) {
        this.svd = DecompositionFactory.svd(n, n2, true, true, true);
    }

    public SolvePseudoInverseSvd() {
        this(100, 100);
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        int n;
        this.pinv.reshape(denseMatrix64F.numCols, denseMatrix64F.numRows, false);
        if (!this.svd.decompose(denseMatrix64F)) {
            return false;
        }
        DenseMatrix64F denseMatrix64F2 = this.svd.getU(null, true);
        DenseMatrix64F denseMatrix64F3 = this.svd.getV(null, false);
        double[] dArray = this.svd.getSingularValues();
        int n2 = Math.min(denseMatrix64F.numRows, denseMatrix64F.numCols);
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        double d2 = this.threshold * (double)Math.max(denseMatrix64F.numCols, denseMatrix64F.numRows) * d;
        if (d != 0.0) {
            for (n = 0; n < n2; ++n) {
                double d3 = dArray[n];
                dArray[n] = d3 < d2 ? 0.0 : 1.0 / dArray[n];
            }
        }
        for (n = 0; n < denseMatrix64F3.numRows; ++n) {
            int n3 = n * denseMatrix64F3.numCols;
            for (int i = 0; i < denseMatrix64F3.numCols; ++i) {
                int n4 = n3++;
                denseMatrix64F3.data[n4] = denseMatrix64F3.data[n4] * dArray[i];
            }
        }
        CommonOps.mult(denseMatrix64F3, denseMatrix64F2, this.pinv);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        CommonOps.mult(this.pinv, denseMatrix64F, denseMatrix64F2);
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        denseMatrix64F.set(this.pinv);
    }

    @Override
    public boolean modifiesA() {
        return this.svd.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public SingularValueDecomposition<DenseMatrix64F> getDecomposition() {
        return this.svd;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public SingularValueDecomposition<DenseMatrix64F> getDecomposer() {
        return this.svd;
    }
}

