/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholder_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrHouse_D64
extends LinearSolverAbstract_D64 {
    private QRDecompositionHouseholder_D64 decomposer = new QRDecompositionHouseholder_D64();
    private double[] a;
    private double[] u;
    private int maxRows = -1;
    private DenseMatrix64F QR;
    private double[] gammas;

    public void setMaxSize(int n) {
        this.maxRows = n;
        this.a = new double[n];
        this.u = new double[n];
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxRows) {
            this.setMaxSize(denseMatrix64F.numRows);
        }
        this._setA(denseMatrix64F);
        if (!this.decomposer.decompose(denseMatrix64F)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(this.QR);
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.a[n2] = denseMatrix64F.data[n2 * n + i];
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                int n3;
                this.u[n2] = 1.0;
                double d = this.a[n2];
                for (n3 = n2 + 1; n3 < this.numRows; ++n3) {
                    this.u[n3] = this.QR.unsafe_get(n3, n2);
                    d += this.u[n3] * this.a[n3];
                }
                d *= this.gammas[n2];
                for (n3 = n2; n3 < this.numRows; ++n3) {
                    int n4 = n3;
                    this.a[n4] = this.a[n4] - this.u[n3] * d;
                }
            }
            TriangularSolver.solveU(this.QR.data, this.a, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.data[n2 * denseMatrix64F2.numCols + i] = this.a[n2];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

