/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.decompose.qr.QRDecompositionHouseholder_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverQrHouse_CD64
extends LinearSolverAbstract_CD64 {
    private QRDecompositionHouseholder_CD64 decomposer = new QRDecompositionHouseholder_CD64();
    private double[] a;
    private double[] u;
    private int maxRows = -1;
    private CDenseMatrix64F QR;
    private double[] gammas;

    public void setMaxSize(int n) {
        this.maxRows = n;
        this.a = new double[n * 2];
        this.u = new double[n * 2];
    }

    @Override
    public boolean setA(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows > this.maxRows) {
            this.setMaxSize(cDenseMatrix64F.numRows);
        }
        this._setA(cDenseMatrix64F);
        if (!this.decomposer.decompose(cDenseMatrix64F)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        return true;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.QR);
    }

    @Override
    public void solve(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != cDenseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = cDenseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                int n3 = (n2 * n + i) * 2;
                this.a[n2 * 2] = cDenseMatrix64F.data[n3];
                this.a[n2 * 2 + 1] = cDenseMatrix64F.data[n3 + 1];
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                int n4;
                this.u[n2 * 2] = 1.0;
                this.u[n2 * 2 + 1] = 0.0;
                double d = this.a[2 * n2];
                double d2 = this.a[2 * n2 + 1];
                for (n4 = n2 + 1; n4 < this.numRows; ++n4) {
                    int n5 = (n4 * this.QR.numCols + n2) * 2;
                    double d3 = this.QR.data[n5];
                    this.u[n4 * 2] = d3;
                    double d4 = d3;
                    double d5 = this.QR.data[n5 + 1];
                    this.u[n4 * 2 + 1] = d5;
                    double d6 = d5;
                    double d7 = this.a[n4 * 2];
                    double d8 = this.a[n4 * 2 + 1];
                    d += d4 * d7 + d6 * d8;
                    d2 += d4 * d8 - d6 * d7;
                }
                d *= this.gammas[n2];
                d2 *= this.gammas[n2];
                for (n4 = n2; n4 < this.numRows; ++n4) {
                    double d9 = this.u[n4 * 2];
                    double d10 = this.u[n4 * 2 + 1];
                    int n6 = n4 * 2;
                    this.a[n6] = this.a[n6] - (d9 * d - d10 * d2);
                    int n7 = n4 * 2 + 1;
                    this.a[n7] = this.a[n7] - (d9 * d2 + d10 * d);
                }
            }
            CTriangularSolver.solveU(this.QR.data, this.a, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                int n8 = (n2 * cDenseMatrix64F2.numCols + i) * 2;
                cDenseMatrix64F2.data[n8] = this.a[n2 * 2];
                cDenseMatrix64F2.data[n8 + 1] = this.a[n2 * 2 + 1];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<CDenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

