/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.decompose.qr.QRDecompositionHouseholderTran_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverQrHouseTran_CD64
extends LinearSolverAbstract_CD64 {
    private QRDecompositionHouseholderTran_CD64 decomposer = new QRDecompositionHouseholderTran_CD64();
    private double[] a;
    protected int maxRows = -1;
    protected int maxCols = -1;
    private CDenseMatrix64F QR;
    private CDenseMatrix64F U;

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.a = new double[n * 2];
    }

    @Override
    public boolean setA(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows > this.maxRows || cDenseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        }
        this._setA(cDenseMatrix64F);
        if (!this.decomposer.decompose(cDenseMatrix64F)) {
            return false;
        }
        this.QR = this.decomposer.getQR();
        return true;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.QR);
    }

    @Override
    public void solve(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + cDenseMatrix64F2.numRows + " expected = " + this.numCols);
        }
        if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != cDenseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        this.U = this.decomposer.getR(this.U, true);
        double[] dArray = this.decomposer.getGammas();
        double[] dArray2 = this.QR.data;
        int n = cDenseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.numRows; ++n3) {
                n2 = (n3 * n + i) * 2;
                this.a[n3 * 2] = cDenseMatrix64F.data[n2];
                this.a[n3 * 2 + 1] = cDenseMatrix64F.data[n2 + 1];
            }
            for (n3 = 0; n3 < this.numCols; ++n3) {
                double d;
                double d2;
                int n4;
                n2 = (n3 * this.numRows + n3 + 1) * 2;
                double d3 = this.a[n3 * 2];
                double d4 = this.a[n3 * 2 + 1];
                for (n4 = n3 + 1; n4 < this.numRows; ++n4) {
                    d2 = dArray2[n2++];
                    d = -dArray2[n2++];
                    double d5 = this.a[n4 * 2];
                    double d6 = this.a[n4 * 2 + 1];
                    d3 += d2 * d5 - d * d6;
                    d4 += d2 * d6 + d * d5;
                }
                int n5 = n3 * 2;
                this.a[n5] = this.a[n5] - (d3 *= dArray[n3]);
                int n6 = n3 * 2 + 1;
                this.a[n6] = this.a[n6] - (d4 *= dArray[n3]);
                n2 = (n3 * this.numRows + n3 + 1) * 2;
                for (n4 = n3 + 1; n4 < this.numRows; ++n4) {
                    d2 = dArray2[n2++];
                    d = dArray2[n2++];
                    int n7 = n4 * 2;
                    this.a[n7] = this.a[n7] - (d2 * d3 - d * d4);
                    int n8 = n4 * 2 + 1;
                    this.a[n8] = this.a[n8] - (d2 * d4 + d * d3);
                }
            }
            CTriangularSolver.solveU(this.U.data, this.a, this.numCols);
            for (n3 = 0; n3 < this.numCols; ++n3) {
                n2 = (n3 * cDenseMatrix64F2.numCols + i) * 2;
                cDenseMatrix64F2.data[n2] = this.a[n3 * 2];
                cDenseMatrix64F2.data[n2 + 1] = this.a[n3 * 2 + 1];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<CDenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

