/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrHouseCol_D64
extends LinearSolverAbstract_D64 {
    private QRDecompositionHouseholderColumn_D64 decomposer;
    private DenseMatrix64F a = new DenseMatrix64F(1, 1);
    private DenseMatrix64F temp = new DenseMatrix64F(1, 1);
    protected int maxRows = -1;
    protected int maxCols = -1;
    private double[][] QR;
    private DenseMatrix64F R = new DenseMatrix64F(1, 1);
    private double[] gammas;

    public LinearSolverQrHouseCol_D64() {
        this.decomposer = new QRDecompositionHouseholderColumn_D64();
    }

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows < denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Can't solve for wide systems.  More variables than equations.");
        }
        if (denseMatrix64F.numRows > this.maxRows || denseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        }
        this.R.reshape(denseMatrix64F.numCols, denseMatrix64F.numCols);
        this.a.reshape(denseMatrix64F.numRows, 1);
        this.temp.reshape(denseMatrix64F.numRows, 1);
        this._setA(denseMatrix64F);
        if (!this.decomposer.decompose(denseMatrix64F)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(this.R);
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + denseMatrix64F2.numRows + " expected = " + this.numCols);
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.a.data[n2] = denseMatrix64F.data[n2 * n + i];
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                double[] dArray = this.QR[n2];
                double d = dArray[n2];
                dArray[n2] = 1.0;
                QrHelperFunctions_D64.rank1UpdateMultR(this.a, dArray, this.gammas[n2], 0, n2, this.numRows, this.temp.data);
                dArray[n2] = d;
            }
            TriangularSolver.solveU(this.R.data, this.a.data, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.data[n2 * denseMatrix64F2.numCols + i] = this.a.data[n2];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

