/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import java.util.Arrays;
import org.ejml.alg.dense.decompose.lu.LUDecompositionBase_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;

public abstract class LinearSolverLuBase_CD64
extends LinearSolverAbstract_CD64 {
    protected LUDecompositionBase_CD64 decomp;

    public LinearSolverLuBase_CD64(LUDecompositionBase_CD64 lUDecompositionBase_CD64) {
        this.decomp = lUDecompositionBase_CD64;
    }

    @Override
    public boolean setA(CDenseMatrix64F cDenseMatrix64F) {
        this._setA(cDenseMatrix64F);
        return this.decomp.decompose(cDenseMatrix64F);
    }

    @Override
    public double quality() {
        return this.decomp.quality();
    }

    @Override
    public void invert(CDenseMatrix64F cDenseMatrix64F) {
        double[] dArray = this.decomp._getVV();
        CDenseMatrix64F cDenseMatrix64F2 = this.decomp.getLU();
        if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numCols || cDenseMatrix64F.numRows != cDenseMatrix64F2.numRows) {
            throw new IllegalArgumentException("Unexpected matrix dimension");
        }
        int n = this.A.numCols;
        double[] dArray2 = cDenseMatrix64F.data;
        int n2 = cDenseMatrix64F.getRowStride();
        for (int i = 0; i < n; ++i) {
            Arrays.fill(dArray, 0, n * 2, 0.0);
            dArray[i * 2] = 1.0;
            dArray[i * 2 + 1] = 0.0;
            this.decomp._solveVectorInternal(dArray);
            int n3 = i * 2;
            int n4 = 0;
            while (n4 < n) {
                dArray2[n3] = dArray[n4 * 2];
                dArray2[n3 + 1] = dArray[n4 * 2 + 1];
                ++n4;
                n3 += n2;
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public LUDecompositionBase_CD64 getDecomposition() {
        return this.decomp;
    }
}

