/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.EjmlParameters;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.decomposition.qr.QRDecompositionHouseholder_B64;
import org.ejml.alg.dense.decomposition.BaseDecomposition_B64_to_D64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CommonOps;

public class QRDecomposition_B64_to_D64
extends BaseDecomposition_B64_to_D64
implements QRDecomposition<DenseMatrix64F> {
    public QRDecomposition_B64_to_D64() {
        super(new QRDecompositionHouseholder_B64(), EjmlParameters.BLOCK_WIDTH);
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        int n = Math.min(this.Ablock.numRows, this.Ablock.numCols);
        if (denseMatrix64F == null) {
            if (bl) {
                denseMatrix64F = new DenseMatrix64F(this.Ablock.numRows, n);
                CommonOps.setIdentity(denseMatrix64F);
            } else {
                denseMatrix64F = new DenseMatrix64F(this.Ablock.numRows, this.Ablock.numRows);
                CommonOps.setIdentity(denseMatrix64F);
            }
        }
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F();
        blockMatrix64F.numRows = denseMatrix64F.numRows;
        blockMatrix64F.numCols = denseMatrix64F.numCols;
        blockMatrix64F.blockLength = this.blockLength;
        blockMatrix64F.data = denseMatrix64F.data;
        ((QRDecompositionHouseholder_B64)this.alg).getQ(blockMatrix64F, bl);
        this.convertBlockToRow(denseMatrix64F.numRows, denseMatrix64F.numCols, this.Ablock.blockLength, denseMatrix64F.data);
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getR(DenseMatrix64F denseMatrix64F, boolean bl) {
        BlockMatrix64F blockMatrix64F = ((QRDecompositionHouseholder_B64)this.alg).getR((BlockMatrix64F)null, bl);
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(blockMatrix64F.numRows, blockMatrix64F.numCols);
        }
        BlockMatrixOps.convert(blockMatrix64F, denseMatrix64F);
        return denseMatrix64F;
    }
}

