/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.data.DenseMatrix64F;

public class LUDecompositionNR_D64
extends LUDecompositionBase_D64 {
    private static final double TINY = 1.0E-40;

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        double d;
        int n;
        this.decomposeCommonInit(denseMatrix64F);
        for (n = 0; n < this.m; ++n) {
            double d2 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                d = Math.abs(this.dataLU[n * this.n + i]);
                if (!(d2 < d)) continue;
                d2 = d;
            }
            if (d2 == 0.0) {
                d2 = 1.0;
            }
            this.vv[n] = 1.0 / d2;
        }
        for (n = 0; n < this.n; ++n) {
            int n2;
            int n3;
            int n4;
            int n5 = -1;
            double d3 = 0.0;
            for (n4 = n; n4 < this.m; ++n4) {
                double d4 = this.vv[n4] * this.dataLU[n4 * this.n + n];
                if (d4 < 0.0) {
                    d4 = -d4;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
                n5 = n4;
            }
            if (n5 < 0) {
                this.indx[n] = -1;
                return true;
            }
            if (n != n5) {
                int n6;
                n4 = n5 * this.n;
                n3 = n6 + this.n;
                for (n6 = n * this.n; n6 < n3; ++n6) {
                    double d5 = this.dataLU[n4];
                    this.dataLU[n4] = this.dataLU[n6];
                    this.dataLU[n6] = d5;
                    ++n4;
                }
                this.pivsign = -this.pivsign;
                this.vv[n5] = this.vv[n];
                n2 = this.pivot[n5];
                this.pivot[n5] = this.pivot[n];
                this.pivot[n] = n2;
            }
            this.indx[n] = n5;
            d = this.dataLU[n * this.n + n];
            if (d == 0.0) {
                this.dataLU[n * this.n + n] = 1.0E-40;
                d = 1.0E-40;
            }
            for (n3 = n + 1; n3 < this.m; ++n3) {
                n2 = n3 * this.n;
                int n7 = n2 + n;
                double d6 = this.dataLU[n7] / d;
                this.dataLU[n7] = d6;
                double d7 = d6;
                int n8 = n * this.n + n + 1;
                int n9 = n2 + this.n;
                n2 += n + 1;
                while (n2 < n9) {
                    int n10 = n2++;
                    this.dataLU[n10] = this.dataLU[n10] - d7 * this.dataLU[n8];
                    ++n8;
                }
            }
        }
        return true;
    }
}

