/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionHouseholderOrig_D64 {
    DenseMatrix64F QT = new DenseMatrix64F(this.N, this.N);
    int N = 1;
    double[] w = new double[this.N];
    double[] gammas;
    double[] b = new double[this.N];

    public TridiagonalDecompositionHouseholderOrig_D64() {
        this.gammas = new double[this.N];
    }

    public DenseMatrix64F getQT() {
        return this.QT;
    }

    public DenseMatrix64F getT(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != denseMatrix64F.numRows || this.N != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            denseMatrix64F.zero();
        }
        denseMatrix64F.data[0] = this.QT.data[0];
        denseMatrix64F.data[1] = this.QT.data[1];
        for (int i = 1; i < this.N - 1; ++i) {
            denseMatrix64F.set(i, i, this.QT.get(i, i));
            denseMatrix64F.set(i, i + 1, this.QT.get(i, i + 1));
            denseMatrix64F.set(i, i - 1, this.QT.get(i - 1, i));
        }
        denseMatrix64F.data[(this.N - 1) * this.N + this.N - 1] = this.QT.data[(this.N - 1) * this.N + this.N - 1];
        denseMatrix64F.data[(this.N - 1) * this.N + this.N - 2] = this.QT.data[(this.N - 2) * this.N + this.N - 1];
        return denseMatrix64F;
    }

    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F) {
        int n;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.N, this.N);
            for (n = 0; n < this.N; ++n) {
                denseMatrix64F.data[n * this.N + n] = 1.0;
            }
        } else {
            if (this.N != denseMatrix64F.numRows || this.N != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (n = 0; n < this.N; ++n) {
            this.w[n] = 0.0;
        }
        for (n = this.N - 2; n >= 0; --n) {
            this.w[n + 1] = 1.0;
            for (int i = n + 2; i < this.N; ++i) {
                this.w[i] = this.QT.get(n, i);
            }
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, this.w, this.gammas[n + 1], n + 1, n + 1, this.N, this.b);
        }
        return denseMatrix64F;
    }

    public void decompose(DenseMatrix64F denseMatrix64F) {
        this.init(denseMatrix64F);
        for (int i = 1; i < this.N; ++i) {
            this.similarTransform(i);
        }
    }

    private void similarTransform(int n) {
        double[] dArray = this.QT.data;
        double d = 0.0;
        int n2 = (n - 1) * this.N;
        for (int i = n; i < this.N; ++i) {
            double d2 = Math.abs(dArray[n2 + i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            double d3;
            double d4 = 0.0;
            for (int i = n; i < this.N; ++i) {
                int n3 = n2 + i;
                double d5 = dArray[n3] / d;
                dArray[n3] = d5;
                double d6 = d5;
                d4 += d6 * d6;
            }
            d4 = Math.sqrt(d4);
            if (dArray[n2 + n] < 0.0) {
                d4 = -d4;
            }
            double d7 = dArray[n2 + n] + d4;
            dArray[n2 + n] = 1.0;
            for (int i = n + 1; i < this.N; ++i) {
                int n4 = n2 + i;
                dArray[n4] = dArray[n4] / d7;
            }
            this.gammas[n] = d3 = d7 / d4;
            this.householderSymmetric(n, d3);
            dArray[n2 + n] = -d4 * d;
        } else {
            this.gammas[n] = 0.0;
        }
    }

    public void householderSymmetric(int n, double d) {
        int n2;
        int n3 = (n - 1) * this.N;
        for (int i = n; i < this.N; ++i) {
            double d2 = 0.0;
            for (int j = n; j < this.N; ++j) {
                d2 += this.QT.data[i * this.N + j] * this.QT.data[n3 + j];
            }
            this.w[i] = -d * d2;
        }
        double d3 = 0.0;
        for (n2 = n; n2 < this.N; ++n2) {
            d3 += this.QT.data[n3 + n2] * this.w[n2];
        }
        d3 *= -0.5 * d;
        for (n2 = n; n2 < this.N; ++n2) {
            int n4 = n2;
            this.w[n4] = this.w[n4] + d3 * this.QT.data[n3 + n2];
        }
        for (n2 = n; n2 < this.N; ++n2) {
            double d4 = this.w[n2];
            double d5 = this.QT.data[n3 + n2];
            for (int i = n2; i < this.N; ++i) {
                int n5 = n2 * this.N + i;
                double d6 = this.QT.data[n5] + (d4 * this.QT.data[n3 + i] + this.w[i] * d5);
                this.QT.data[n5] = d6;
                this.QT.data[i * this.N + n2] = d6;
            }
        }
    }

    public void init(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Must be square");
        }
        if (denseMatrix64F.numCols != this.N) {
            this.N = denseMatrix64F.numCols;
            this.QT.reshape(this.N, this.N, false);
            if (this.w.length < this.N) {
                this.w = new double[this.N];
                this.gammas = new double[this.N];
                this.b = new double[this.N];
            }
        }
        this.QT.set(denseMatrix64F);
    }

    public double getGamma(int n) {
        return this.gammas[n];
    }
}

