/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class EigenPowerMethod {
    private double tol = 1.0E-10;
    private DenseMatrix64F q0;
    private DenseMatrix64F q1;
    private DenseMatrix64F q2;
    private int maxIterations = 20;
    private DenseMatrix64F B;
    private DenseMatrix64F seed;

    public EigenPowerMethod(int n) {
        this.q0 = new DenseMatrix64F(n, 1);
        this.q1 = new DenseMatrix64F(n, 1);
        this.q2 = new DenseMatrix64F(n, 1);
        this.B = new DenseMatrix64F(n, n);
    }

    public void setSeed(DenseMatrix64F denseMatrix64F) {
        this.seed = denseMatrix64F;
    }

    public void setOptions(int n, double d) {
        this.maxIterations = n;
        this.tol = d;
    }

    public boolean computeDirect(DenseMatrix64F denseMatrix64F) {
        this.initPower(denseMatrix64F);
        boolean bl = false;
        for (int i = 0; i < this.maxIterations && !bl; ++i) {
            CommonOps.mult(denseMatrix64F, this.q0, this.q1);
            double d = NormOps.normPInf(this.q1);
            CommonOps.divide(this.q1, d, (D1Matrix64F)this.q2);
            bl = this.checkConverged(denseMatrix64F);
        }
        return bl;
    }

    private void initPower(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("A must be a square matrix.");
        }
        if (this.seed != null) {
            this.q0.set(this.seed);
        } else {
            for (int i = 0; i < denseMatrix64F.numRows; ++i) {
                this.q0.data[i] = 1.0;
            }
        }
    }

    private boolean checkConverged(DenseMatrix64F denseMatrix64F) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            double d3 = Math.abs(this.q2.data[i] - this.q0.data[i]);
            if (d3 > d) {
                d = d3;
            }
            if (!((d3 = Math.abs(this.q2.data[i] + this.q0.data[i])) > d2)) continue;
            d2 = d3;
        }
        DenseMatrix64F denseMatrix64F2 = this.q0;
        this.q0 = this.q2;
        this.q2 = denseMatrix64F2;
        if (d < this.tol) {
            return true;
        }
        return d2 < this.tol;
    }

    public boolean computeShiftDirect(DenseMatrix64F denseMatrix64F, double d) {
        SpecializedOps.addIdentity(denseMatrix64F, this.B, -d);
        return this.computeDirect(this.B);
    }

    public boolean computeShiftInvert(DenseMatrix64F denseMatrix64F, double d) {
        this.initPower(denseMatrix64F);
        LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.linear(denseMatrix64F.numCols);
        SpecializedOps.addIdentity(denseMatrix64F, this.B, -d);
        linearSolver.setA(this.B);
        boolean bl = false;
        for (int i = 0; i < this.maxIterations && !bl; ++i) {
            linearSolver.solve(this.q0, this.q1);
            double d2 = NormOps.normPInf(this.q1);
            CommonOps.divide(this.q1, d2, (D1Matrix64F)this.q2);
            bl = this.checkConverged(denseMatrix64F);
        }
        return bl;
    }

    public DenseMatrix64F getEigenVector() {
        return this.q0;
    }
}

