/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.bidiagonal;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.BidiagonalDecomposition;
import org.ejml.ops.CommonOps;

public class BidiagonalDecompositionRow_D64
implements BidiagonalDecomposition<DenseMatrix64F> {
    private DenseMatrix64F UBV;
    private int m;
    private int n;
    private int min;
    private double[] gammasU;
    private double[] gammasV;
    private double[] b;
    private double[] u;

    public BidiagonalDecompositionRow_D64(int n) {
        this.UBV = new DenseMatrix64F(n);
        this.gammasU = new double[n];
        this.gammasV = new double[n];
        this.b = new double[n];
        this.u = new double[n];
    }

    public BidiagonalDecompositionRow_D64() {
        this(1);
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.init(denseMatrix64F);
        return this._decompose();
    }

    protected void init(DenseMatrix64F denseMatrix64F) {
        this.UBV = denseMatrix64F;
        this.m = this.UBV.numRows;
        this.n = this.UBV.numCols;
        this.min = Math.min(this.m, this.n);
        int n = Math.max(this.m, this.n);
        if (this.b.length < n + 1) {
            this.b = new double[n + 1];
            this.u = new double[n + 1];
        }
        if (this.gammasU.length < this.m) {
            this.gammasU = new double[this.m];
        }
        if (this.gammasV.length < this.n) {
            this.gammasV = new double[this.n];
        }
    }

    public DenseMatrix64F getUBV() {
        return this.UBV;
    }

    @Override
    public void getDiagonal(double[] dArray, double[] dArray2) {
        dArray[0] = this.UBV.get(0);
        for (int i = 1; i < this.n; ++i) {
            dArray[i] = this.UBV.unsafe_get(i, i);
            dArray2[i - 1] = this.UBV.unsafe_get(i - 1, i);
        }
    }

    @Override
    public DenseMatrix64F getB(DenseMatrix64F denseMatrix64F, boolean bl) {
        denseMatrix64F = BidiagonalDecompositionRow_D64.handleB(denseMatrix64F, bl, this.m, this.n, this.min);
        denseMatrix64F.set(0, 0, this.UBV.get(0, 0));
        for (int i = 1; i < this.min; ++i) {
            denseMatrix64F.set(i, i, this.UBV.get(i, i));
            denseMatrix64F.set(i - 1, i, this.UBV.get(i - 1, i));
        }
        if (this.n > this.m) {
            denseMatrix64F.set(this.min - 1, this.min, this.UBV.get(this.min - 1, this.min));
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F handleB(DenseMatrix64F denseMatrix64F, boolean bl, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n2 > n ? n3 + 1 : n3;
        if (bl) {
            if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(n3, n4);
            } else {
                denseMatrix64F.reshape(n3, n4, false);
                denseMatrix64F.zero();
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n, n2);
        } else {
            denseMatrix64F.reshape(n, n2, false);
            denseMatrix64F.zero();
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getU(DenseMatrix64F denseMatrix64F, boolean bl, boolean bl2) {
        int n;
        denseMatrix64F = BidiagonalDecompositionRow_D64.handleU(denseMatrix64F, bl, bl2, this.m, this.n, this.min);
        CommonOps.setIdentity(denseMatrix64F);
        for (n = 0; n < this.m; ++n) {
            this.u[n] = 0.0;
        }
        for (n = this.min - 1; n >= 0; --n) {
            this.u[n] = 1.0;
            for (int i = n + 1; i < this.m; ++i) {
                this.u[i] = this.UBV.get(i, n);
            }
            if (bl) {
                QrHelperFunctions_D64.rank1UpdateMultL(denseMatrix64F, this.u, this.gammasU[n], n, n, this.m);
                continue;
            }
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, this.u, this.gammasU[n], n, n, this.m, this.b);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F handleU(DenseMatrix64F denseMatrix64F, boolean bl, boolean bl2, int n, int n2, int n3) {
        if (bl2) {
            if (bl) {
                if (denseMatrix64F == null) {
                    denseMatrix64F = new DenseMatrix64F(n3, n);
                } else {
                    denseMatrix64F.reshape(n3, n, false);
                }
            } else if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(n, n3);
            } else {
                denseMatrix64F.reshape(n, n3, false);
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n, n);
        } else {
            denseMatrix64F.reshape(n, n, false);
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getV(DenseMatrix64F denseMatrix64F, boolean bl, boolean bl2) {
        denseMatrix64F = BidiagonalDecompositionRow_D64.handleV(denseMatrix64F, bl, bl2, this.m, this.n, this.min);
        CommonOps.setIdentity(denseMatrix64F);
        for (int i = this.min - 1; i >= 0; --i) {
            this.u[i + 1] = 1.0;
            for (int j = i + 2; j < this.n; ++j) {
                this.u[j] = this.UBV.get(i, j);
            }
            if (bl) {
                QrHelperFunctions_D64.rank1UpdateMultL(denseMatrix64F, this.u, this.gammasV[i], i + 1, i + 1, this.n);
                continue;
            }
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, this.u, this.gammasV[i], i + 1, i + 1, this.n, this.b);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F handleV(DenseMatrix64F denseMatrix64F, boolean bl, boolean bl2, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n2 > n ? n3 + 1 : n3;
        if (bl2) {
            if (bl) {
                if (denseMatrix64F == null) {
                    denseMatrix64F = new DenseMatrix64F(n4, n2);
                } else {
                    denseMatrix64F.reshape(n4, n2, false);
                }
            } else if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(n2, n4);
            } else {
                denseMatrix64F.reshape(n2, n4, false);
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n2, n2);
        } else {
            denseMatrix64F.reshape(n2, n2, false);
        }
        return denseMatrix64F;
    }

    private boolean _decompose() {
        for (int i = 0; i < this.min; ++i) {
            this.computeU(i);
            this.computeV(i);
        }
        return true;
    }

    protected void computeU(int n) {
        double[] dArray = this.UBV.data;
        double d = 0.0;
        for (int i = n; i < this.m; ++i) {
            double d2 = this.u[i] = dArray[i * this.n + n];
            if (!((d2 = Math.abs(d2)) > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            double d3;
            double d4 = QrHelperFunctions_D64.computeTauAndDivide(n, this.m, this.u, d);
            double d5 = this.u[n] + d4;
            QrHelperFunctions_D64.divideElements_Bcol(n + 1, this.m, this.n, this.u, dArray, n, d5);
            this.u[n] = 1.0;
            this.gammasU[n] = d3 = d5 / d4;
            QrHelperFunctions_D64.rank1UpdateMultR(this.UBV, this.u, d3, n + 1, n, this.m, this.b);
            dArray[n * this.n + n] = -d4 * d;
        } else {
            this.gammasU[n] = 0.0;
        }
    }

    protected void computeV(int n) {
        double[] dArray = this.UBV.data;
        int n2 = n * this.n;
        double d = QrHelperFunctions_D64.findMax(dArray, n2 + n + 1, this.n - n - 1);
        if (d > 0.0) {
            double d2;
            double d3 = QrHelperFunctions_D64.computeTauAndDivide(n + 1, this.n, dArray, n2, d);
            double d4 = dArray[n2 + n + 1] + d3;
            QrHelperFunctions_D64.divideElements_Brow(n + 2, this.n, this.u, dArray, n2, d4);
            this.u[n + 1] = 1.0;
            this.gammasV[n] = d2 = d4 / d3;
            QrHelperFunctions_D64.rank1UpdateMultL(this.UBV, this.u, d2, n + 1, n + 1, this.n);
            dArray[n2 + n + 1] = -d3 * d;
        } else {
            this.gammasV[n] = 0.0;
        }
    }

    public double[] getGammasU() {
        return this.gammasU;
    }

    public double[] getGammasV() {
        return this.gammasV;
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

