/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;

public class QrHelperFunctions_CD64 {
    public static double findMax(double[] dArray, int n, int n2) {
        double d = -1.0;
        int n3 = n * 2;
        int n4 = (n + n2) * 2;
        while (n3 < n4) {
            double d2 = dArray[n3++];
            int n5 = n3++;
            double d3 = dArray[n5];
            double d4 = d2 * d2 + d3 * d3;
            if (!(d4 > d)) continue;
            d = d4;
        }
        return Math.sqrt(d);
    }

    public static void divideElements(int n, int n2, double[] dArray, int n3, double d, double d2) {
        double d3 = d * d + d2 * d2;
        int n4 = (n + n3) * 2;
        for (int i = n; i < n2; ++i) {
            double d4 = dArray[n4];
            double d5 = dArray[n4 + 1];
            dArray[n4++] = (d4 * d + d5 * d2) / d3;
            dArray[n4++] = (d5 * d - d4 * d2) / d3;
        }
    }

    public static double computeTauGammaAndDivide(int n, int n2, double[] dArray, double d, Complex64F complex64F) {
        double d2;
        double d3;
        int n3 = n * 2;
        double d4 = 0.0;
        for (int i = n; i < n2; ++i) {
            int n4 = n3++;
            double d5 = dArray[n4] / d;
            dArray[n4] = d5;
            double d6 = d5;
            int n5 = n3++;
            double d7 = dArray[n5] / d;
            dArray[n5] = d7;
            double d8 = d7;
            d4 += d6 * d6 + d8 * d8;
        }
        d4 = Math.sqrt(d4);
        double d9 = dArray[2 * n];
        double d10 = dArray[2 * n + 1];
        double d11 = Math.sqrt(d9 * d9 + d10 * d10);
        if (d11 == 0.0) {
            complex64F.real = d4;
            complex64F.imaginary = 0.0;
        } else {
            complex64F.real = d9 / d11 * d4;
            complex64F.imaginary = d10 / d11 * d4;
        }
        if (d9 * complex64F.real < 0.0) {
            complex64F.real = -complex64F.real;
            complex64F.imaginary = -complex64F.imaginary;
            d3 = d4 * d4 - d4 * d11;
            d2 = d11 * d11 - 2.0 * d4 * d11 + d4 * d4;
        } else {
            d3 = d4 * d4 + d4 * d11;
            d2 = d11 * d11 + 2.0 * d4 * d11 + d4 * d4;
        }
        return d2 / d3;
    }

    public static void rank1UpdateMultR(CDenseMatrix64F cDenseMatrix64F, double[] dArray, int n, double d, int n2, int n3, int n4, double[] dArray2) {
        double d2;
        double d3;
        double d4;
        int n5;
        int n6 = (n3 + n) * 2;
        double d5 = dArray[n6];
        double d6 = -dArray[n6 + 1];
        int n7 = n3 * cDenseMatrix64F.numCols * 2 + n2 * 2;
        int n8 = n2 * 2;
        for (n5 = n2; n5 < cDenseMatrix64F.numCols; ++n5) {
            double d7 = cDenseMatrix64F.data[n7++];
            d4 = cDenseMatrix64F.data[n7++];
            dArray2[n8++] = d5 * d7 - d6 * d4;
            dArray2[n8++] = d5 * d4 + d6 * d7;
        }
        for (n5 = n3 + 1; n5 < n4; ++n5) {
            n7 = n5 * cDenseMatrix64F.numCols * 2 + n2 * 2;
            n6 = (n5 + n) * 2;
            n8 = n2 * 2;
            d5 = dArray[n6];
            d6 = -dArray[n6 + 1];
            for (int i = n2; i < cDenseMatrix64F.numCols; ++i) {
                d3 = cDenseMatrix64F.data[n7++];
                d2 = cDenseMatrix64F.data[n7++];
                int n9 = n8++;
                dArray2[n9] = dArray2[n9] + (d5 * d3 - d6 * d2);
                int n10 = n8++;
                dArray2[n10] = dArray2[n10] + (d5 * d2 + d6 * d3);
            }
        }
        n8 = n2 * 2;
        for (n5 = n2; n5 < cDenseMatrix64F.numCols; ++n5) {
            double d8 = dArray2[n8];
            d4 = dArray2[n8 + 1];
            dArray2[n8++] = d * d8;
            dArray2[n8++] = d * d4;
        }
        for (n5 = n3; n5 < n4; ++n5) {
            n7 = n5 * cDenseMatrix64F.numCols * 2 + n2 * 2;
            n6 = (n5 + n) * 2;
            n8 = n2 * 2;
            d5 = dArray[n6];
            d6 = dArray[n6 + 1];
            for (int i = n2; i < cDenseMatrix64F.numCols; ++i) {
                d3 = dArray2[n8++];
                d2 = dArray2[n8++];
                int n11 = n7++;
                cDenseMatrix64F.data[n11] = cDenseMatrix64F.data[n11] - (d5 * d3 - d6 * d2);
                int n12 = n7++;
                cDenseMatrix64F.data[n12] = cDenseMatrix64F.data[n12] - (d5 * d2 + d6 * d3);
            }
        }
    }

    public static void rank1UpdateMultL(CDenseMatrix64F cDenseMatrix64F, double[] dArray, double d, double d2, int n, int n2, int n3) {
        for (int i = n; i < cDenseMatrix64F.numRows; ++i) {
            double d3;
            double d4;
            int n4 = i * cDenseMatrix64F.numCols * 2 + n2 * 2;
            double d5 = 0.0;
            double d6 = 0.0;
            int n5 = n4;
            int n6 = n2 * 2;
            for (int j = n2; j < n3; ++j) {
                double d7 = cDenseMatrix64F.data[n5++];
                double d8 = cDenseMatrix64F.data[n5++];
                d4 = dArray[n6++];
                d3 = dArray[n6++];
                d5 += d7 * d4 - d8 * d3;
                d6 += d7 * d3 + d8 * d4;
            }
            double d9 = -(d * d5 - d2 * d6);
            double d10 = -(d * d6 + d2 * d5);
            n5 = n4;
            n6 = n2 * 2;
            for (int j = n2; j < n3; ++j) {
                d4 = dArray[n6++];
                d3 = -dArray[n6++];
                int n7 = n5++;
                cDenseMatrix64F.data[n7] = cDenseMatrix64F.data[n7] + (d9 * d4 - d10 * d3);
                int n8 = n5++;
                cDenseMatrix64F.data[n8] = cDenseMatrix64F.data[n8] + (d9 * d3 + d10 * d4);
            }
        }
    }
}

