/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;

public class QRDecompositionHouseholder_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected CDenseMatrix64F QR;
    protected double[] u;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] dataQR;
    protected double[] gammas;
    protected double realGamma;
    protected double realTau;
    protected double imagTau;
    protected boolean error;

    public void setExpectedMaxSize(int n, int n2) {
        this.error = false;
        this.numCols = n2;
        this.numRows = n;
        this.minLength = Math.min(n, n2);
        int n3 = Math.max(n, n2);
        if (this.QR == null) {
            this.QR = new CDenseMatrix64F(n, n2);
            this.u = new double[n3 * 2];
            this.v = new double[n3 * 2];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(n, n2);
        }
        this.dataQR = this.QR.data;
        if (this.u.length < n3 * 2) {
            this.u = new double[n3 * 2];
            this.v = new double[n3 * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public CDenseMatrix64F getQR() {
        return this.QR;
    }

    @Override
    public CDenseMatrix64F getQ(CDenseMatrix64F cDenseMatrix64F, boolean bl) {
        if (bl) {
            if (cDenseMatrix64F == null) {
                cDenseMatrix64F = CCommonOps.identity(this.numRows, this.minLength);
            } else {
                if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CCommonOps.setIdentity(cDenseMatrix64F);
            }
        } else if (cDenseMatrix64F == null) {
            cDenseMatrix64F = CCommonOps.identity(this.numRows);
        } else {
            if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CCommonOps.setIdentity(cDenseMatrix64F);
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            this.u[2 * i] = 1.0;
            this.u[2 * i + 1] = 0.0;
            for (int j = i + 1; j < this.numRows; ++j) {
                int n = this.QR.getIndex(j, i);
                this.u[j * 2] = this.QR.data[n];
                this.u[j * 2 + 1] = this.QR.data[n + 1];
            }
            QrHelperFunctions_CD64.rank1UpdateMultR(cDenseMatrix64F, this.u, 0, this.gammas[i], i, i, this.numRows, this.v);
        }
        return cDenseMatrix64F;
    }

    @Override
    public CDenseMatrix64F getR(CDenseMatrix64F cDenseMatrix64F, boolean bl) {
        int n;
        int n2;
        int n3;
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = bl ? new CDenseMatrix64F(this.minLength, this.numCols) : new CDenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (bl ? cDenseMatrix64F.numCols != this.numCols || cDenseMatrix64F.numRows != this.minLength : cDenseMatrix64F.numCols != this.numCols || cDenseMatrix64F.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (n3 = 0; n3 < cDenseMatrix64F.numRows; ++n3) {
                n2 = Math.min(n3, cDenseMatrix64F.numCols);
                for (n = 0; n < n2; ++n) {
                    cDenseMatrix64F.set(n3, n, 0.0, 0.0);
                }
            }
        }
        for (n3 = 0; n3 < this.minLength; ++n3) {
            for (n2 = n3; n2 < this.numCols; ++n2) {
                n = this.QR.getIndex(n3, n2);
                double d = this.QR.data[n];
                double d2 = this.QR.data[n + 1];
                cDenseMatrix64F.set(n3, n2, d, d2);
            }
        }
        return cDenseMatrix64F;
    }

    @Override
    public boolean decompose(CDenseMatrix64F cDenseMatrix64F) {
        this.commonSetup(cDenseMatrix64F);
        for (int i = 0; i < this.minLength; ++i) {
            this.householder(i);
            this.updateA(i);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int n) {
        double d;
        double d2;
        int n2 = 2 * (n + n * this.numCols);
        int n3 = 2 * n;
        double d3 = 0.0;
        for (int i = n; i < this.numRows; ++i) {
            int n4 = n3++;
            double d4 = this.dataQR[n2];
            this.u[n4] = d4;
            double d5 = d4;
            double d6 = this.u[n3++] = this.dataQR[n2 + 1];
            d2 = d6;
            d = d5 * d5 + d2 * d2;
            if (d3 < d) {
                d3 = d;
            }
            n2 += this.numCols * 2;
        }
        if ((d3 = Math.sqrt(d3)) == 0.0) {
            this.realGamma = 0.0;
            this.error = true;
        } else {
            double d7;
            double d8;
            double d9 = 0.0;
            n3 = 2 * n;
            for (int i = n; i < this.numRows; ++i) {
                int n5 = n3++;
                double d10 = this.u[n5] / d3;
                this.u[n5] = d10;
                d2 = d10;
                int n6 = n3++;
                double d11 = this.u[n6] / d3;
                this.u[n6] = d11;
                d = d11;
                d9 += d2 * d2 + d * d;
            }
            d9 = Math.sqrt(d9);
            double d12 = this.u[2 * n];
            double d13 = this.u[2 * n + 1];
            double d14 = Math.sqrt(d12 * d12 + d13 * d13);
            if (d14 == 0.0) {
                this.realTau = d9;
                this.imagTau = 0.0;
            } else {
                this.realTau = d12 / d14 * d9;
                this.imagTau = d13 / d14 * d9;
            }
            if (d12 * this.realTau < 0.0) {
                this.realTau = -this.realTau;
                this.imagTau = -this.imagTau;
                d8 = d9 * d9 - d9 * d14;
                d7 = d14 * d14 - 2.0 * d9 * d14 + d9 * d9;
            } else {
                d8 = d9 * d9 + d9 * d14;
                d7 = d14 * d14 + 2.0 * d9 * d14 + d9 * d9;
            }
            this.realGamma = d7 / d8;
            double d15 = d12 + this.realTau;
            double d16 = d13 + this.imagTau;
            double d17 = d15 * d15 + d16 * d16;
            n3 = (n + 1) * 2;
            for (int i = n + 1; i < this.numRows; ++i) {
                double d18 = this.u[n3];
                double d19 = this.u[n3 + 1];
                this.u[n3++] = (d18 * d15 + d19 * d16) / d17;
                this.u[n3++] = (d19 * d15 - d18 * d16) / d17;
            }
            this.u[2 * n] = 1.0;
            this.u[2 * n + 1] = 0.0;
            this.realTau *= d3;
            this.imagTau *= d3;
        }
        this.gammas[n] = this.realGamma;
    }

    protected void updateA(int n) {
        double d;
        int n2;
        int n3 = this.numCols * 2;
        double d2 = this.u[n * 2];
        double d3 = -this.u[n * 2 + 1];
        int n4 = n * n3 + (n + 1) * 2;
        for (n2 = n + 1; n2 < this.numCols; ++n2) {
            double d4 = this.dataQR[n4++];
            d = this.dataQR[n4++];
            this.v[n2 * 2] = d2 * d4 - d3 * d;
            this.v[n2 * 2 + 1] = d2 * d + d3 * d4;
        }
        for (n2 = n + 1; n2 < this.numRows; ++n2) {
            d2 = this.u[n2 * 2];
            d3 = -this.u[n2 * 2 + 1];
            n4 = n2 * n3 + (n + 1) * 2;
            for (int i = n + 1; i < this.numCols; ++i) {
                double d5 = this.dataQR[n4++];
                double d6 = this.dataQR[n4++];
                int n5 = i * 2;
                this.v[n5] = this.v[n5] + (d2 * d5 - d3 * d6);
                int n6 = i * 2 + 1;
                this.v[n6] = this.v[n6] + (d2 * d6 + d3 * d5);
            }
        }
        for (n2 = n + 1; n2 < this.numCols; ++n2) {
            int n7 = n2 * 2;
            this.v[n7] = this.v[n7] * this.realGamma;
            int n8 = n2 * 2 + 1;
            this.v[n8] = this.v[n8] * this.realGamma;
        }
        for (n2 = n; n2 < this.numRows; ++n2) {
            double d7 = this.u[n2 * 2];
            d = this.u[n2 * 2 + 1];
            n4 = n2 * n3 + (n + 1) * 2;
            for (int i = n + 1; i < this.numCols; ++i) {
                double d8 = this.v[i * 2];
                double d9 = this.v[i * 2 + 1];
                int n9 = n4++;
                this.dataQR[n9] = this.dataQR[n9] - (d7 * d8 - d * d9);
                int n10 = n4++;
                this.dataQR[n10] = this.dataQR[n10] - (d7 * d9 + d * d8);
            }
        }
        if (n < this.numCols) {
            this.dataQR[2 * n + n * n3] = -this.realTau;
            this.dataQR[2 * n + n * n3 + 1] = -this.imagTau;
        }
        for (n2 = n + 1; n2 < this.numRows; ++n2) {
            this.dataQR[2 * n + n2 * n3] = this.u[n2 * 2];
            this.dataQR[2 * n + n2 * n3 + 1] = this.u[n2 * 2 + 1];
        }
    }

    protected void commonSetup(CDenseMatrix64F cDenseMatrix64F) {
        this.setExpectedMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        this.QR.set(cDenseMatrix64F);
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

