/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.lu;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.CSpecializedOps;

public abstract class LUDecompositionBase_CD64
implements LUDecomposition<CDenseMatrix64F> {
    protected CDenseMatrix64F LU;
    protected int maxWidth = -1;
    protected int m;
    protected int n;
    protected int stride;
    protected double[] dataLU;
    protected double[] vv;
    protected int[] indx;
    protected int[] pivot;
    protected double pivsign;
    protected Complex64F det = new Complex64F();

    public void setExpectedMaxSize(int n, int n2) {
        this.LU = new CDenseMatrix64F(n, n2);
        this.dataLU = this.LU.data;
        this.maxWidth = Math.max(n, n2);
        this.vv = new double[this.maxWidth * 2];
        this.indx = new int[this.maxWidth];
        this.pivot = new int[this.maxWidth];
    }

    public CDenseMatrix64F getLU() {
        return this.LU;
    }

    public int[] getIndx() {
        return this.indx;
    }

    public int[] getPivot() {
        return this.pivot;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    @Override
    public CDenseMatrix64F getLower(CDenseMatrix64F cDenseMatrix64F) {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.LU.numRows;
        int n7 = n5 = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = new CDenseMatrix64F(n6, n5);
        } else {
            if (cDenseMatrix64F.numCols != n5 || cDenseMatrix64F.numRows != n6) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CCommonOps.fill(cDenseMatrix64F, 0.0, 0.0);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            cDenseMatrix64F.set(n4, n4, 1.0, 0.0);
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.LU.getIndex(n4, n3);
                n = cDenseMatrix64F.getIndex(n4, n3);
                d2 = this.LU.data[n2];
                d = this.LU.data[n2 + 1];
                cDenseMatrix64F.data[n] = d2;
                cDenseMatrix64F.data[n + 1] = d;
            }
        }
        if (n6 > n5) {
            for (n4 = n5; n4 < n6; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    n2 = this.LU.getIndex(n4, n3);
                    n = cDenseMatrix64F.getIndex(n4, n3);
                    d2 = this.LU.data[n2];
                    d = this.LU.data[n2 + 1];
                    cDenseMatrix64F.data[n] = d2;
                    cDenseMatrix64F.data[n + 1] = d;
                }
            }
        }
        return cDenseMatrix64F;
    }

    @Override
    public CDenseMatrix64F getUpper(CDenseMatrix64F cDenseMatrix64F) {
        int n = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        int n2 = this.LU.numCols;
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = new CDenseMatrix64F(n, n2);
        } else {
            if (cDenseMatrix64F.numCols != n2 || cDenseMatrix64F.numRows != n) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CCommonOps.fill(cDenseMatrix64F, 0.0, 0.0);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n2; ++j) {
                int n3 = this.LU.getIndex(i, j);
                int n4 = cDenseMatrix64F.getIndex(i, j);
                double d = this.LU.data[n3];
                double d2 = this.LU.data[n3 + 1];
                cDenseMatrix64F.data[n4] = d;
                cDenseMatrix64F.data[n4 + 1] = d2;
            }
        }
        return cDenseMatrix64F;
    }

    @Override
    public CDenseMatrix64F getPivot(CDenseMatrix64F cDenseMatrix64F) {
        return CSpecializedOps.pivotMatrix(cDenseMatrix64F, this.pivot, this.LU.numRows, false);
    }

    protected void decomposeCommonInit(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows > this.maxWidth || cDenseMatrix64F.numCols > this.maxWidth) {
            this.setExpectedMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        }
        this.m = cDenseMatrix64F.numRows;
        this.n = cDenseMatrix64F.numCols;
        this.stride = this.n * 2;
        this.LU.set(cDenseMatrix64F);
        for (int i = 0; i < this.m; ++i) {
            this.pivot[i] = i;
        }
        this.pivsign = 1.0;
    }

    @Override
    public boolean isSingular() {
        for (int i = 0; i < this.m; ++i) {
            double d = this.dataLU[i * this.stride + i * 2];
            double d2 = this.dataLU[i * this.stride + i * 2 + 1];
            double d3 = d * d + d2 * d2;
            if (!(d3 < UtilEjml.EPS * UtilEjml.EPS)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Complex64F computeDeterminant() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        double d = this.pivsign;
        double d2 = 0.0;
        int n = this.m * this.stride;
        for (int i = 0; i < n; i += this.stride + 2) {
            double d3 = this.dataLU[i];
            double d4 = this.dataLU[i + 1];
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            d = d5;
            d2 = d6;
        }
        this.det.set(d, d2);
        return this.det;
    }

    public double quality() {
        return CSpecializedOps.qualityTriangular(this.LU);
    }

    public void _solveVectorInternal(double[] dArray) {
        this.solveL(dArray);
        CTriangularSolver.solveU(this.dataLU, dArray, this.n);
    }

    protected void solveL(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            int n2 = this.indx[i];
            double d = dArray[n2 * 2];
            double d2 = dArray[n2 * 2 + 1];
            dArray[n2 * 2] = dArray[i * 2];
            dArray[n2 * 2 + 1] = dArray[i * 2 + 1];
            if (n != 0) {
                int n3 = i * this.stride + (n - 1) * 2;
                for (int j = n - 1; j < i; ++j) {
                    double d3 = this.dataLU[n3++];
                    double d4 = this.dataLU[n3++];
                    double d5 = dArray[j * 2];
                    double d6 = dArray[j * 2 + 1];
                    d -= d3 * d5 - d4 * d6;
                    d2 -= d3 * d6 + d4 * d5;
                }
            } else if (d * d + d2 * d2 != 0.0) {
                n = i + 1;
            }
            dArray[i * 2] = d;
            dArray[i * 2 + 1] = d2;
        }
    }

    public double[] _getVV() {
        return this.vv;
    }
}

