/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.linsol.qr;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.qr.QRDecompositionHouseholder_B64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.SpecializedOps;

public class BlockQrHouseHolderSolver
implements LinearSolver<BlockMatrix64F> {
    protected QRDecompositionHouseholder_B64 decomposer = new QRDecompositionHouseholder_B64();
    protected BlockMatrix64F QR;

    public BlockQrHouseHolderSolver() {
        this.decomposer.setSaveW(false);
    }

    @Override
    public boolean setA(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F.numRows < blockMatrix64F.numCols) {
            throw new IllegalArgumentException("Number of rows must be more than or equal to the number of columns.  Can't solve an underdetermined system.");
        }
        if (!this.decomposer.decompose(blockMatrix64F)) {
            return false;
        }
        this.QR = this.decomposer.getQR();
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(this.decomposer.getQR());
    }

    @Override
    public void solve(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F.numCols != blockMatrix64F2.numCols) {
            throw new IllegalArgumentException("Columns of B and X do not match");
        }
        if (this.QR.numCols != blockMatrix64F2.numRows) {
            throw new IllegalArgumentException("Rows in X do not match the columns in A");
        }
        if (this.QR.numRows != blockMatrix64F.numRows) {
            throw new IllegalArgumentException("Rows in B do not match the rows in A.");
        }
        if (blockMatrix64F.blockLength != this.QR.blockLength || blockMatrix64F2.blockLength != this.QR.blockLength) {
            throw new IllegalArgumentException("All matrices must have the same block length.");
        }
        this.decomposer.applyQTran(blockMatrix64F);
        BlockMatrixOps.extractAligned(blockMatrix64F, blockMatrix64F2);
        int n = Math.min(this.QR.numRows, this.QR.numCols);
        BlockTriangularSolver.solve(this.QR.blockLength, true, new D1Submatrix64F(this.QR, 0, n, 0, n), new D1Submatrix64F(blockMatrix64F2), false);
    }

    @Override
    public void invert(BlockMatrix64F blockMatrix64F) {
        int n = Math.min(this.QR.numRows, this.QR.numCols);
        if (blockMatrix64F.numRows != n || blockMatrix64F.numCols != n) {
            throw new IllegalArgumentException("A_inv must be square an have dimension " + n);
        }
        BlockMatrixOps.setIdentity(blockMatrix64F);
        this.decomposer.applyQTran(blockMatrix64F);
        BlockTriangularSolver.solve(this.QR.blockLength, true, new D1Submatrix64F(this.QR, 0, n, 0, n), new D1Submatrix64F(blockMatrix64F), false);
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return true;
    }

    @Override
    public QRDecomposition<BlockMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

