/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GeneratorBlockInnerMultiplication {
    String className;
    PrintStream stream;

    public GeneratorBlockInnerMultiplication(String string) throws FileNotFoundException {
        this.className = string;
        this.stream = new PrintStream(string + ".java");
    }

    public void createClass() {
        this.printTop();
        for (int i = 0; i < 2; ++i) {
            boolean bl = i == 1;
            for (Operation operation : Operation.values()) {
                if (bl && operation == Operation.MINUS) continue;
                this.print_mult(bl, operation);
                this.print_multTransA(bl, operation);
                this.print_multTransB(bl, operation);
            }
        }
        this.stream.print("}\n");
    }

    private void printTop() {
        String string = "/*\n * Copyright (c) 2009-2013, Peter Abeles. All Rights Reserved.\n *\n * This file is part of Efficient Java Matrix Library (EJML).\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage org.ejml.alg.block;\n\n/**\n * <p>\n * Matrix multiplication for the inner row major blocks, typically inside of a {@link org.ejml.data.BlockMatrix64F}.\n * </p>\n *\n * <p>\n * This code was auto generated by {@link GeneratorBlockInnerMultiplication} and should not be modified directly.\n * </p>\n *\n * @author Peter Abeles\n */\npublic class " + this.className + " {\n";
        this.stream.print(string);
    }

    private void print_mult(boolean bl, Operation operation) {
        this.createHeader(bl, operation, false, false);
        this.stream.print("//        for( int i = 0; i < heightA; i++ ) {\n//            for( int k = 0; k < widthA; k++ ) {\n//                for( int j = 0; j < widthC; j++ ) {\n//                    dataC[ i*widthC + j + indexC ] += dataA[i*widthA + k + indexA] * dataB[k*widthC + j + indexB];\n//                }\n//            }\n//        }\n");
        this.stream.println();
        String string = operation == Operation.MINUS ? "-=" : "+=";
        String string2 = bl ? "alpha*" : "";
        this.stream.print("        int a = indexA;\n        int rowC = indexC;\n        for( int i = 0; i < heightA; i++ , rowC += widthC ) {\n            int b = indexB;\n\n            final int endC = rowC + widthC;\n            final int endA = a + widthA;\n            while( a != endA ) {//for( int k = 0; k < widthA; k++ ) {\n                double valA = " + string2 + "dataA[a++];\n" + "\n" + "                int c = rowC;\n" + "\n");
        if (operation == Operation.SET) {
            this.stream.print("                if( b == indexB ) {\n                    while( c != endC  ) {//for( int j = 0; j < widthC; j++ ) {\n                        dataC[ c++ ] = valA * dataB[ b++ ];\n                    }\n                } else {\n                    while( c != endC  ) {//for( int j = 0; j < widthC; j++ ) {\n                        dataC[ c++ ] " + string + " valA * dataB[ b++ ];\n" + "                    }\n" + "                }\n");
        } else {
            this.stream.print("                while( c != endC  ) {//for( int j = 0; j < widthC; j++ ) {\n                    dataC[ c++ ] " + string + " valA * dataB[ b++ ];\n" + "                }\n");
        }
        this.stream.println("            }\n        }");
        this.stream.println("    }");
    }

    private String createOpString(boolean bl, Operation operation) {
        String string = this.opString(operation);
        if (bl) {
            string = string + " alpha * ";
        }
        return string;
    }

    private void print_multTransA(boolean bl, Operation operation) {
        this.createHeader(bl, operation, true, false);
        String string = operation == Operation.MINUS ? "-=" : "+=";
        String string2 = bl ? "alpha*" : "";
        this.stream.print("//        for( int i = 0; i < widthA; i++ ) {\n//            for( int k = 0; k < heightA; k++ ) {\n//                double valA = dataA[k*widthA + i + indexA];\n//                for( int j = 0; j < widthC; j++ ) {\n//                    dataC[ i*widthC + j + indexC ] += valA * dataB[k*widthC + j + indexB];\n//                }\n//            }\n//        }\n");
        this.stream.println();
        this.stream.print("        int rowC = indexC;\n        for( int i = 0; i < widthA; i++ , rowC += widthC) {\n            int colA = i + indexA;\n            int endA = colA + widthA*heightA;\n            int b = indexB;\n\n            // for( int k = 0; k < heightA; k++ ) {\n            while(colA != endA ) {\n                double valA = " + string2 + "dataA[colA];\n" + "\n" + "                int c = rowC;\n" + "                final int endB = b + widthC;\n" + "\n" + "                //for( int j = 0; j < widthC; j++ ) {\n");
        if (operation == Operation.SET) {
            this.stream.print("                if( b == indexB ) {\n                    while( b != endB ) {\n                        dataC[ c++ ] = valA * dataB[b++];\n                    } \n                } else {\n                    while( b != endB ) {\n                        dataC[ c++ ] " + string + " valA * dataB[b++];\n" + "                    }\n" + "                }\n");
        } else {
            this.stream.print("                while( b != endB ) {\n                    dataC[ c++ ] " + string + " valA * dataB[b++];\n" + "                }\n");
        }
        this.stream.print("                colA += widthA;\n            }\n        }\n");
        this.stream.println("    }");
    }

    private void print_multTransB(boolean bl, Operation operation) {
        this.createHeader(bl, operation, false, true);
        String string = this.createOpString(bl, operation);
        this.stream.println("        for( int i = 0; i < heightA; i++ ) {\n            for( int j = 0; j < widthC; j++ ) {\n                double val = 0;\n\n                for( int k = 0; k < widthA; k++ ) {\n                    val += dataA[i*widthA + k + indexA] * dataB[j*widthA + k + indexB];\n                }\n\n                dataC[ i*widthC + j + indexC ] " + string + " val;\n" + "            }\n" + "        }");
        this.stream.println("    }");
    }

    private void createHeader(boolean bl, Operation operation, boolean bl2, boolean bl3) {
        String string;
        String string2 = bl ? " &alpha; " : "";
        String string3 = bl ? " double alpha ," : "";
        String string4 = bl2 ? "<sup>T</sup>" : "";
        String string5 = bl3 ? "<sup>T</sup>" : "";
        switch (operation) {
            case MINUS: {
                string = "C - ";
                break;
            }
            case PLUS: {
                string = "C + ";
                break;
            }
            case SET: {
                string = "";
                break;
            }
            default: {
                throw new RuntimeException("Unknown optype");
            }
        }
        String string6 = "blockMult" + this.opName(operation);
        if (bl2 && bl3) {
            string6 = string6 + "TransAB";
        } else if (bl2) {
            string6 = string6 + "TransA";
        } else if (bl3) {
            string6 = string6 + "TransB";
        }
        this.stream.println();
        this.stream.print("    /**\n     * <p>\n     * Performs the follow operation on individual inner blocks:<br>\n     * <br>\n");
        this.stream.print("     * C = " + string + string2 + "A" + string4 + " * B" + string5 + "\n");
        this.stream.print("     * </p>\n     */\n    public static void " + string6 + "(" + string3 + " final double[] dataA, final double []dataB, final double []dataC,\n" + "                                     int indexA, int indexB, int indexC,\n" + "                                     final int heightA, final int widthA, final int widthC) {\n");
    }

    private String opString(Operation operation) {
        switch (operation) {
            case MINUS: {
                return "-=";
            }
            case PLUS: {
                return "+=";
            }
            case SET: {
                return "=";
            }
        }
        throw new RuntimeException("Unknown opType " + (Object)((Object)operation));
    }

    private String opName(Operation operation) {
        switch (operation) {
            case MINUS: {
                return "Minus";
            }
            case PLUS: {
                return "Plus";
            }
            case SET: {
                return "Set";
            }
        }
        throw new RuntimeException("Unknown opType " + (Object)((Object)operation));
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        GeneratorBlockInnerMultiplication generatorBlockInnerMultiplication = new GeneratorBlockInnerMultiplication("BlockInnerMultiplication");
        generatorBlockInnerMultiplication.createClass();
        System.out.println("Done generating class");
    }

    private static enum Operation {
        PLUS,
        MINUS,
        SET;

    }
}

